/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: LaunchItem.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// LaunchItem.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.workitem;

import openwfe.org.Utils;
import openwfe.org.time.Time;
import openwfe.org.engine.expressions.FlowExpressionId;


/**
 * When listeners listen to this, they will attempt to launch a workflow
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 09:08:10 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: LaunchItem.java 3087 2006-08-30 07:08:10Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class LaunchItem

    extends WorkItem

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(LaunchItem.class.getName());
    */

    //
    // FIELDS

    private String workflowDefinitionUrl = null;
    private StringMapAttribute descriptionMap = null;

    private FlowExpressionId replyTo = null;

    //
    // CONSTRUCTORS

    /**
     * Builds an empty launch item.
     */
    public LaunchItem ()
    {
        super();
    }

    /**
     * Builds a launchitem
     *
     * @param wfdUrl the URL of the process definition to instantiate
     * @param replyTo the FlowExpressionId of an expression awaiting for this
     * flow to launch, execute and terminate
     * @param wi the workitem as given by the 'replyTo' expression
     */
    public LaunchItem 
        (final String wfdUrl,
         final FlowExpressionId replyTo,
         final InFlowWorkItem wi)
    {
        super();

        this.workflowDefinitionUrl = wfdUrl;

        this.setReplyTo(replyTo);

        if (wi != null)
            this.setAttributes(wi.getAttributes());
    }

    //
    // BEAN METHODS

    /**
     * Returns the id of the expression waiting for the launched
     * [sub]flow to end
     */
    public FlowExpressionId getReplyTo ()
    {
        return this.replyTo;
    }

    /**
     * Returns the workflow definition URL pointing to the definition
     * this launchitem item wants to get launched.
     */
    public String getWorkflowDefinitionUrl () 
    { 
        return this.workflowDefinitionUrl; 
    }

    /**
     * This description map takes languages codes as keys (fr, en, pt, )
     * and String descriptions as values.
     */
    public StringMapAttribute getDescriptionMap () 
    { 
        return this.descriptionMap; 
    }

    /**
     * Sets the id of the expression waiting for the launched
     * [sub]flow to end
     */
    public void setReplyTo (final FlowExpressionId fei)
    {
        this.replyTo = fei;
    }

    public void setWorkflowDefinitionUrl (final String s) 
    { 
        this.workflowDefinitionUrl = s; 
    }

    public void setDescriptionMap (final StringMapAttribute m) 
    { 
        this.descriptionMap = m; 
    }

    //
    // METHODS

    /**
     * Produces an exact replica of this InFlowWorkItem
     */
    public Object clone ()
    {
        LaunchItem clone = new LaunchItem ();

        //clone.setLastModified
        //    (Utils.copyString(getLastModified()));
        clone.setLastModified(Time.toIsoDate());

        clone.setAttributes
            ((StringMapAttribute)getAttributes().clone());

        clone.setWorkflowDefinitionUrl
            (Utils.copyString(getWorkflowDefinitionUrl()));
        clone.setDescriptionMap
            ((StringMapAttribute)getDescriptionMap().clone());

        clone.setReplyTo(getReplyTo().copy());

        return clone;
    }

}
