/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: InFlowWorkItem.java 3398 2006-09-28 00:12:47Z jmettraux $
 */

//
// InFlowWorkItem.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.workitem;

import openwfe.org.Utils;
import openwfe.org.time.Time;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.participants.Filter;


/**
 * A workitem travelling among the execution tree of a running workflow 
 * instance.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-09-28 02:12:47 +0200 (Thu, 28 Sep 2006) $
 * <br>$Id: InFlowWorkItem.java 3398 2006-09-28 00:12:47Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class InFlowWorkItem

    extends InFlowItem

{

    static final long serialVersionUID = 4549009226611843819L;

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(InFlowWorkItem.class.getName());
    */

    //
    // FIELDS

    /**
     * This field is set to the datetime string corresponding to when the
     * workitem got dispatched to a participant (when the workitem left the
     * engine), so it's relevant only outside of the engine.
     */
    private String dispatchTime = null;

    /**
     * When dispatched to a participant, this participant has perhaps a filter
     * set on him in the process definition, this filter may be thus attached
     * at dispatch time to the workitem and the worklist, reactor or whatever 
     * corresponding to the participant. 
     * The 'external' application may then use the filter (differentiate
     * 'read-write' from 'read-only' or choose not to care about it.
     * The engine will anyway take care of enforcing the filter when
     * the workitem comes back to it.
     */
    private Filter filter = null;

    /**
     * A list of HistoryItem instances, one for each of the workflow steps
     * this workitem went through.
     */
    private java.util.List history = null;

    //
    // CONSTRUCTORS

    /**
     * A simple constructor for building an empty workitem, the 
     * listener or any other application logic using it has next to fill
     * it and tag it properly...
     */
    public InFlowWorkItem ()
    {
        super();
    }

    /**
     * This constructor is used at launch time, to turn a launchitem
     * into an InFlowWorkItem and start the flow.
     */
    public InFlowWorkItem (final LaunchItem li)
    {
        super();

        this.setAttributes(li.getAttributes());
        this.setHistory(new java.util.ArrayList(0));
    }

    /**
     * (This constructor is only used by VariableMap).
     */
    public InFlowWorkItem (final StringMapAttribute sma)
    {
        super();
        
        this.setAttributes(sma);
        this.setHistory(new java.util.ArrayList(0));
    }

    //
    // BEAN METHODS

    public String getDispatchTime () { return this.dispatchTime; }
    public Filter getFilter () { return this.filter; }
    public java.util.List getHistory () { return this.history; }


    public void setDispatchTime (String isoDate) { this.dispatchTime = isoDate; }
    public void setFilter (Filter f) { this.filter = f; }
    public void setHistory (java.util.List l) { this.history = l; }

    //
    // METHODS

    /**
     * Returns the id of the last expression this InFlowWorkItem transited
     * through (or simply the fei of the expression that emitted this 
     * workitem out of the engine).
     */
    public FlowExpressionId getLastExpressionId ()
    {
        return this.getId();
    }

    /**
     * Adds a HistoryItem to the history list of the workitem.
     */
    public void addHistoryItem 
        (final String author, final String text)
    {
        addHistoryItem(null, author, text);
    }

    /**
     * Adds a HistoryItem to the history list of the workitem.
     * This peculiar method is used by FlowExpression instances to 
     * tag a workitem when it passed through them. Usually only
     * a ParticipantExpression does this, for when the workitem crosses
     * it.
     */
    public void addHistoryItem 
        (FlowExpressionId fei, final String author, final String text)
    {
        HistoryItem hi = new HistoryItem();

        hi.setAuthor(author);
        hi.setDate(Time.toIsoDate());
        hi.setText(text);

        if (fei == null) 
            fei = getLastExpressionId();

        if (fei != null)
        {
            hi.setWorkflowDefinitionName
                (fei.getWorkflowDefinitionName());
            hi.setWorkflowDefinitionRevision
                (fei.getWorkflowDefinitionRevision());
            hi.setWorkflowInstanceId
                (fei.getWorkflowInstanceId());
        }

        try
        {
            java.net.InetAddress add = java.net.InetAddress.getLocalHost();
            hi.setHost(add.getHostName()+" / "+add.getHostAddress());
        }
        catch (java.net.UnknownHostException uhe)
        {
            hi.setHost(""+uhe);
        }

        if (this.history == null) this.history = new java.util.ArrayList(1);

        this.history.add(hi);
    }

    /**
     * Produces an exact replica of this InFlowWorkItem
     */
    public Object clone ()
    {
        InFlowWorkItem clone = new InFlowWorkItem ();

        clone.setAttributes((StringMapAttribute)getAttributes().clone());

        if (getId() != null) clone.setId(getId().copy());

        clone.setParticipantName(Utils.copyString(getParticipantName()));
        clone.setDispatchTime(Utils.copyString(getDispatchTime()));
        clone.setLastModified(Time.toIsoDate());
        clone.setFilter(getFilter());
        clone.setHistory(HistoryItem.copyHistoryList(this.history));

        return clone;
    }

}
