/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: CollectionAttribute.java 3334 2006-09-17 06:19:18Z jmettraux $
 */

//
// CollectionAttribute.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.workitem;

/**
 * Providing a few common methods for MapAttribute and ListAttribute.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-09-17 08:19:18 +0200 (Sun, 17 Sep 2006) $
 * <br>$Id: CollectionAttribute.java 3334 2006-09-17 06:19:18Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class CollectionAttribute

    implements Attribute

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(CollectionAttribute.class.getName());

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    /**
     * For a map attribute, the key will really be a string for a list
     * attribute, the key will be the integer index of the element to 'get'.
     */
    public abstract Attribute cget (String key);

    /**
     * For a map attribute, the key will really be a string for a list
     * attribute, the key will be the integer index of the element to 'get'.
     * 'cput' stands for 'collection put'.
     */
    public abstract void cput (String key, Attribute value);

    public abstract Object clone ();

    /**
     * Returns the size of this attribute (the number of direct children
     * it has).
     */
    public abstract int size ();

    //
    // STATIC METHODS

    /**
     * Given a key and a CollectionAttribute, looks up the attribute stored in
     * the collection corresponding to the key.
     * The key may be a hierarchy of keys separted by dots like in 
     * "customer.name.lastname" or "customers-list.0".<br>
     * This method is used by openwfe.org.engine.expressions.VariableMap to
     * replace things like ${f:customer.name} or ${f:customer} by their
     * actual values.
     */
    public static Attribute lookupAttribute 
        (final String key, final CollectionAttribute startPoint)
    {
        //return doLookup(false, key, startPoint);

        final Attribute a = doLookup(false, key, startPoint);

        if (a != null) return a;

        //
        // returning the key 'literally'

        return startPoint.cget(key);
    }

    /**
     * Given a key and a CollectionAttribute, looks up the collection 
     * attribute containing the key.
     */
    public static CollectionAttribute lookupContainer
        (final String key, final CollectionAttribute startPoint)
    {
        return (CollectionAttribute)doLookup(true, key, startPoint);
    }

    private static Attribute doLookup
        (final boolean containerLookup, 
         final String key, 
         final CollectionAttribute startPoint)
    {
        //if (startPoint == null) return null;

        if (key.equals("/") || key.equals("")) return startPoint;

        final int i = key.indexOf(".");

        if (i < 0)
        {
            if (containerLookup) return startPoint;

            return ((CollectionAttribute)startPoint).cget(key);
        }

        final String scar = key.substring(0, i);
        final String scdr = key.substring(i+1);

        if (log.isDebugEnabled())
            log.debug("doLookup() car >"+scar+"<   cdr >"+scdr+"<");

        final Attribute newStartPoint = lookupAttribute(scar, startPoint);

        if (newStartPoint == null)
        {
            //log.debug("doLookup() newStartPoint null, returning null.");
            return null;
        }

        if (newStartPoint instanceof XmlAttribute)
        {
            return XmlAttribute.lookupAsAttribute
                (scdr, ((XmlAttribute)newStartPoint).getContent());
        }

        if ( ! (newStartPoint instanceof CollectionAttribute))
        {
            if (log.isDebugEnabled())
            {
                log.debug
                    ("lookupAttribute() "+
                     "cannot proceed with newStartPoint of class "+
                     newStartPoint.getClass().getName());
            }

            return null;
        }

        return doLookup
            (containerLookup, scdr, (CollectionAttribute)newStartPoint);
    }

}
