/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: FilterEntry.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// FilterEntry.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.00 16.08.2003 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.participants;

/**
 * Relates to how filters are described...
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: FilterEntry.java 3087 2006-08-30 07:08:10Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class FilterEntry

    implements java.io.Serializable

{

    static final long serialVersionUID = 3765701562437365606L;

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(FilterEntry.class.getName());
    */

    //
    // CONSTANTS & co

    //
    // FIELDS

    /**
     * A regular expression that matches the name of one or more (or zero)
     * field names
     */
    protected String fieldRegex = null;

    /**
     * May take the value "rw", "r" or ""
     */
    protected String permissions = null;

    /* *
     * The short name of the attribute type the matched fields should have :
     * 'integer', 'string', 'boolean', 'list', 'map' ...
     *
     *
     * WORK IN (STALLED) PROGRESS
     * /
    protected String attributeType = null;
     *
     */

    //
    // CONSTRUCTORS

    public FilterEntry ()
    {
        super();
    }

    public FilterEntry 
        (final String fieldRegex, final String permissions)
    {
        this.fieldRegex = fieldRegex;
        this.permissions = permissions;
    }

    //
    // METHODS

    public String getFieldRegex () { return this.fieldRegex; }
    public String getPermissions () { return this.permissions; }
    //public String getAttributeType () { return this.attributeType; }

    public void setFieldRegex (String s) { this.fieldRegex = s; }
    public void setPermissions (String s) { this.permissions = s; }
    //public void setAttributeType (String s) { this.attributeType = s; }

}
