/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: CompositeParticipant.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// CompositeParticipant.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.participants;

import openwfe.org.ApplicationContext;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.dispatch.DispatchingException;


/**
 * An aggregation of participants
 *
 * (OBSOLETE FOR NOW)
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 09:08:10 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: CompositeParticipant.java 3087 2006-08-30 07:08:10Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class CompositeParticipant

    extends AbstractParticipant

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(CompositeParticipant.class.getName());

    //
    // FIELDS

    protected java.util.List participants = new java.util.ArrayList(7);

    //
    // CONSTRUCTORS

    /*
    public CompositeParticipant ()
    {
        super();
    }
    */

    //
    // METHODS

    public void add (final Participant p)
    {
        this.participants.add(p);
    }

    /**
     * dispatches to each of the participant
     * contained in this composite
     */
    public Object dispatch 
        (final ApplicationContext context, final WorkItem wi)
    throws 
        DispatchingException
    {
        log.debug("dispatch() composite dspatching");

        Object result = null;
        final java.util.Iterator it = this.participants.iterator();
        while (it.hasNext())
        {
            final Participant p = (Participant)it.next();
            result = p.dispatch(context, wi);
        }
        return result;
    }

}
