/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: WarningReply.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// WarningReply.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.listen.reply;

/**
 * fed back when the dispatching has been successful
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 09:08:10 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: WarningReply.java 3087 2006-08-30 07:08:10Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class WarningReply

    implements ListenerReply

{

    static final long serialVersionUID = -3168892747919870155L;

    //
    // FIELDS

    private String message = null;
    private String exceptionMessage = null;
    private String exceptionStackTrace = null;

    private transient Throwable cause = null;

    //
    // CONSTRUCTORS

    /**
     * An empty constructor, needed because these replies may be
     * transferred as xml encoded beans
     */
    public WarningReply ()
    {
        this.message = "";
    }

    public WarningReply (String message)
    {
        this.message = message;
    }

    public WarningReply (String message, Throwable t)
    {
        this.message = message;

        this.exceptionMessage = t.toString();

        try
        {
            java.io.ByteArrayOutputStream baos = 
                new java.io.ByteArrayOutputStream();
            java.io.PrintWriter pw =
                new java.io.PrintWriter(baos);
            t.printStackTrace(pw);
            pw.flush();
            pw.close();
            baos.close();

            this.exceptionStackTrace = baos.toString();
        }
        catch (java.io.IOException ie)
        {
            this.exceptionStackTrace = "failed to get stack trace";
        }

        this.cause = t;
    }

    //
    // METHODS

    public String getMessage () { return this.message; }
    public String getExceptionMessage () { return this.exceptionMessage; }
    public String getExceptionStackTrace () { return this.exceptionStackTrace; }

    public void setMessage (String s) { this.message = s; }
    public void setExceptionMessage (String s) { this.exceptionMessage = s; }
    public void setExceptionStackTrace (String s) { this.exceptionStackTrace = s; }

    public Throwable getCause () { return this.cause; }

}
