/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ListAttributeCoder.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// ListAttributeCoder.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.impl.workitem.xml;

import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.AttributeCoder;
import openwfe.org.engine.workitem.ListAttribute;
import openwfe.org.engine.workitem.CodingException;


/**
 * Coding/Decoding a list attribute out of / from XML.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 09:08:10 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: ListAttributeCoder.java 3087 2006-08-30 07:08:10Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class ListAttributeCoder

    extends AbstractXmlAttributeCoder

{

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    //
    // METHODS from AttributeCoder

    public Object encode (final Attribute a, final java.util.Map args)
        throws CodingException
    {
        if (a == null) return null;

        ListAttribute la = (ListAttribute)a;

        final org.jdom.Element elt = newElement();
        
        java.util.Iterator it = la.iterator();
        while (it.hasNext())
        {
            Attribute value = (Attribute)it.next();

            AttributeCoder coder = getXmlWorkItemCoder()
                .getAttributeCoder(value);

            elt.addContent((org.jdom.Element)coder.encode(value, null));
        }

        return elt;
    }

    public Attribute decode (final Object o, final java.util.Map args) 
        throws CodingException
    {
        final org.jdom.Element elt = enforceElement(o);

        ListAttribute la = new ListAttribute();

        java.util.Iterator it = elt.getChildren().iterator();
            //
            // there's no getChildren(ns) method...
            // going on without it for now...

        while (it.hasNext())
        {
            org.jdom.Element child = (org.jdom.Element)it.next();

            AttributeCoder coder = getXmlWorkItemCoder()
                .getAttributeCoder(child.getName());

            Attribute a = coder.decode(child, null);

            la.add(a);
        }

        return la;
    }

}
