/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: AbstractXmlAttributeCoder.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// AbstractXmlAttributeCoder.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.impl.workitem.xml;

import openwfe.org.engine.workitem.WorkItemCoder;
import openwfe.org.engine.workitem.CodingException;
import openwfe.org.engine.impl.workitem.AbstractAttributeCoder;


/**
 * The base for an XmlAttributeCoder implementation.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 09:08:10 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: AbstractXmlAttributeCoder.java 3087 2006-08-30 07:08:10Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class AbstractXmlAttributeCoder

    extends AbstractAttributeCoder

{

    //
    // CONSTANTS & co

    public final static String ATTRIBUTE_CLASS = "at-class";
    public final static String REPRESENTATION_NAME = "repr";

    //
    // FIELDS

    private String attributeClassName = null;
    private String representationName = null;

    //
    // CONSTRUCTORS

    public void init 
        (final WorkItemCoder workItemCoder, 
         final java.util.Map params)
    {
        super.init(workItemCoder, params);

        this.attributeClassName = (String)params.get(ATTRIBUTE_CLASS);
        this.representationName = (String)params.get(REPRESENTATION_NAME);

        if (this.attributeClassName == null || 
            this.representationName == null)
        {
            throw new IllegalArgumentException
                ("Attribute '"+ATTRIBUTE_CLASS+
                 "' or '"+REPRESENTATION_NAME+
                 "' is missing from AttributeCoder configuration");
        }
    }

    //
    // METHODS

    public XmlWorkItemCoder getXmlWorkItemCoder ()
    {
        return (XmlWorkItemCoder)this.getWorkItemCoder();
    }

    //
    // METHODS from AttributeCoder

    public String getAttributeClassName ()
    {
        return this.attributeClassName;
    }

    public String getRepresentationName ()
    {
        return this.representationName;
    }

    /**
     * Returns a new XML Element with this representation name as name and
     * the XmlWorkItemCoder namespace.
     */
    public org.jdom.Element newElement ()
    {
        return new org.jdom.Element
            (this.getRepresentationName(), 
             getXmlWorkItemCoder().getNamespace());
    }

    /**
     * A wrap around WicUtils.enforceElement(), it takes care of 
     * passing the representation name as the second param of the 
     * wrapped call.
     */
    public org.jdom.Element enforceElement (final Object o)
        throws CodingException
    {
        return WicUtils.enforceElement(o, this.getRepresentationName());
    }

    //
    // STATIC METHODS

}
