/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: SerialWorkItemCoder.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// SerialWorkItemCoder.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.impl.workitem;

import openwfe.org.ApplicationContext;
import openwfe.org.engine.listen.reply.ListenerReplyCoder;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.WorkItemCoder;
import openwfe.org.engine.workitem.CodingException;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.AttributeCoder;


/**
 * turns a serialized workitem into an instance or the inverse.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 09:08:10 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: SerialWorkItemCoder.java 3087 2006-08-30 07:08:10Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class SerialWorkItemCoder

    implements WorkItemCoder

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(SerialWorkItemCoder.class.getName());
    */

    //
    // FIELDS

    private String name = null;
    private ListenerReplyCoder replyCoder = null;

    //
    // CONSTRUCTORS

    public void init
        (final String name,
         final java.util.List attributeCoders, 
         final ListenerReplyCoder replyCoder,
         final java.util.Map coderParams)
    {
        this.name = name;

        // ignore the attributeCoders list 
        // (it should be set to null anyway)
        
        this.replyCoder = replyCoder;
    }

    //
    // METHODS

    public String getName ()
    {
        return this.name;
    }

    public ListenerReplyCoder getReplyCoder ()
    {
        return this.replyCoder;
    }

    /**
     * Returns the MIME type associated with this [en]coder.
     */
    public String getMimeType ()
    {
        return "application/binary";
            //
            // I can't think of anything better for now
    }

    /**
     * Awaits an input stream, that is read and deserialized into a workitem.
     */
    public WorkItem decode 
        (final Object o,
         final ApplicationContext context,
         final java.util.Map serviceParams) 
    throws 
        CodingException
    {
        //
        // set up input stream

        java.io.InputStream is = null;

        if (o instanceof java.io.InputStream)
        {
            is = (java.io.InputStream)o;
        }
        else
        {
            throw new CodingException
                ("Unsupported WorkItem source : class '"+
                 o.getClass().getName()+"'");
        }

        //
        // let's decode

        WorkItem wi = null;
        try
        {
            java.io.ObjectInputStream decoder = 
                new java.io.ObjectInputStream(is);

            wi = (WorkItem)decoder.readObject();
        }
        catch (Exception e)
        {
            throw new CodingException
                ("Failed to build workitem", e);
        }

        return wi;
    }

    /**
     * Turns the workitem into a byte array (serialized).
     */
    public Object encode 
        (final WorkItem wi, 
         final ApplicationContext context,
         final java.util.Map serviceParams)
    throws 
        CodingException
    {
        try
        {
            return openwfe.org.Utils.serialize(wi);
        }
        catch (java.io.IOException ie)
        {
            throw new CodingException
                ("Failed to encode workitem", ie);
        }
    }

    /**
     * No implementation needed :  Returns null.
     */
    public AttributeCoder getAttributeCoder (final Attribute a)
    {
        return null;
    }

    /**
     * No implementation needed :  Returns null.
     */
    public AttributeCoder getAttributeCoder (final Class attributeClass)
    {
        return null;
    }

    /**
     * No implementation needed :  Returns null.
     */
    public AttributeCoder getAttributeCoder (final String representation)
    {
        return null;
    }

}
