/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: SerialReplyCoder.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// SerialReplyCoder.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.impl.workitem;

import openwfe.org.engine.workitem.CodingException;
import openwfe.org.engine.listen.reply.OkReply;
import openwfe.org.engine.listen.reply.FatalReply;
import openwfe.org.engine.listen.reply.WarningReply;
import openwfe.org.engine.listen.reply.ListenerReply;
import openwfe.org.engine.listen.reply.ListenerReplyCoder;


/**
 * Encoding listener replies.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 09:08:10 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: SerialReplyCoder.java 3087 2006-08-30 07:08:10Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class SerialReplyCoder

    implements ListenerReplyCoder

{

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    //
    // METHODS from ListenerReplyCoder

    /** 
     * catches and  decodes the reply (if any)
     */
    public ListenerReply decode (final Object o)
        throws CodingException
    {
        java.io.InputStream is = null;

        if (o instanceof java.io.InputStream)
        {
            is = (java.io.InputStream)o;
        }

        if (is == null)
        {
            throw new CodingException
                ("Cannot decode object of class '"+o.getClass().getName()+"'");
        }

        try
        {
            java.io.ObjectInputStream ois = new java.io.ObjectInputStream(is);
            return (ListenerReply)ois.readObject();
        }
        catch (Exception e)
        {
            throw new CodingException
                ("Failed to decode ListenerReply", e);
        }
    }

    /**
     * Takes care of properly encoding the reply
     */
    public byte[] encode (final ListenerReply reply)
        throws CodingException
    {
        try
        {
            return openwfe.org.Utils.serialize(reply);
        }
        catch (java.io.IOException ie)
        {
            throw new CodingException
                ("Failed to encode reply", ie);
        }
    }

}
