/*
 * Copyright (c) 2005, Philip Defoort, CirqueDigital.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: LdapParticipantMap.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// LdapService.java
//
// Filip Defoort
//

package openwfe.org.engine.impl.participants;

import java.util.HashMap;
import java.util.Map;

import javax.naming.NamingException;

import openwfe.org.ApplicationContext;
import openwfe.org.ServiceException;
import openwfe.org.ldap.LdapService;
import openwfe.org.engine.participants.AbstractParticipantMap;
import openwfe.org.engine.participants.LeafParticipant;

/**
 * DEPRECATED, will be replaced by LdapParticipantMapFactory;
 *
 * Participant map that gets users and groups from an LDAP server.
 * 
 * @author filipdef
 */
public class LdapParticipantMap 

    extends AbstractParticipantMap 

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
    .getLogger(LdapParticipantMap.class.getName());
    
    private LdapService m_ldapService;
    
    public LdapParticipantMap() {
        super();
    }

    /**
     * Initialization method of this OpenWFE service.
     */
    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        super.init(serviceName, context, serviceParams);

        try {
            // @todo may want to parametrize this as well.
            m_ldapService = (LdapService) getContext().get("ldapService");
            
            if (m_ldapService == null) {
                throw new ServiceException("LDAP Service not found.");
            }
            
            buildMap();
        } catch (NamingException e) {
            throw new ServiceException("LDAP configure error", e);
        }
        
    }
    
    
    protected void refreshMap() throws ServiceException {
    }
    
    protected void buildMap() throws NamingException {
        
        // add engine
        
        // @todo this should come through a composite map.
        LeafParticipant p = new LeafParticipant();
        
        Map params = new HashMap();
        // @todo need to parametrize this as well.
        params.put("host", "127.0.0.1");
        params.put("port", "7007");
        params.put("dispatcherClass", "openwfe.org.engine.impl.dispatch.SocketDispatcher");
        params.put("workItemCoder", "xmlCoder");
        
        //p.init(this, "mainEngine", params);
        p.init("mainEngine", params);
        add(p);
        
        // add groups from ldap
        addGroups();
        
        // add users from ldap
        addUsers();
            
    }

    private void addGroups() throws NamingException {
        String[] groups = m_ldapService.getGroups();
        
        for (int i = 0; i < groups.length; i++) {
            
            LeafParticipant p = new LeafParticipant();
            
            Map params = new HashMap();
            // @todo need to parametrize this as well.
            params.put("host", "127.0.0.1");
            params.put("port", "7008");
            params.put("dispatcherClass", "openwfe.org.engine.impl.dispatch.SocketDispatcher");
            
            //p.init(this, groups[i], params);
            p.init(groups[i], params);

            if (log.isDebugEnabled()) {
                log.debug("LDAP adding " + p.getRegex());
            }
            add(p);
        }
    }
    
    private void addUsers() throws NamingException {
        String[] users = m_ldapService.getUsers();
        
        for (int i = 0; i < users.length; i++) {
            
            LeafParticipant p = new LeafParticipant();
            
            Map params = new HashMap();
            // @todo need to parametrize this as well.
            params.put("host", "127.0.0.1");
            params.put("port", "7008");
            params.put("dispatcherClass", "openwfe.org.engine.impl.dispatch.SocketDispatcher");
            
            //p.init(this, users[i], params);
            p.init(users[i], params);
            
            if (log.isDebugEnabled()) {
                log.debug("LDAP adding " + p.getRegex());
            }
            add(p);
        }
    }
}
