/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: SocketListener.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// SocketListener.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.impl.listen;

import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

import openwfe.org.ExceptionUtils;
import openwfe.org.ApplicationContext;
import openwfe.org.ServiceException;
import openwfe.org.net.SocketService;
import openwfe.org.net.ChannelInputStream;
//import openwfe.org.misc.IoUtils;
import openwfe.org.engine.listen.WorkItemListener;
import openwfe.org.engine.listen.reply.FatalReply;
import openwfe.org.engine.listen.reply.ListenerReply;
import openwfe.org.engine.listen.reply.OkReply;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.WorkItemCoder;
import openwfe.org.engine.workitem.CodingException;


/**
 * Listens for workitems coming from the network
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 09:08:10 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: SocketListener.java 3087 2006-08-30 07:08:10Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class SocketListener

    extends WorkItemListener

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(SocketListener.class.getName());

    //
    // CONSTANTS (definitions)

    public final static String EMBEDDED_SOCKET_SERVICE
        = ".embedded_socket_service";

    //
    // FIELDS

    private SocketService socketService = null;

    //
    // CONSTRUCTORS

    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        // using the super init method is mandatory as it instatiates the
        // work item consumer that the listener will use.

        super.init(serviceName, context, serviceParams);

        //
        // a Socket service is embedded beneath this service
        
        this.socketService = 
            new SocketService()
            {
                public void handle (SelectionKey key)
                    throws ServiceException
                {
                    SocketListener.this.handle(key);
                }

                public org.jdom.Element getStatus ()
                {
                    return new org.jdom.Element(getName());
                }
            };

        this.socketService.setDefaultPort(7007);
            // else if nothing is specified in serviceParams,
            // the server will listen on port 7000...

        this.socketService.init
            (serviceName+EMBEDDED_SOCKET_SERVICE, context, serviceParams);
    }

    //
    // METHODS

    public void stop ()
        throws ServiceException
    {
        try
        {
            this.socketService.stop();
        }
        catch (ServiceException se)
        {
            throw new ServiceException
                ("Embedded SocketService failed to stop correctly", se);
        }

        log.info
            ("Service '"+getName()+"' got stopped.");
    }

    //
    // STATUS

    public org.jdom.Element getStatus ()
    {
        org.jdom.Element status = new org.jdom.Element(getName());
        status.addContent(this.socketService.getStatus());

        return status;
    }

    //
    // HANDLING

    /*
     * reply()
     */
    private void reply 
        (final WorkItemCoder coder,
         final SocketChannel channel, 
         final ListenerReply r)
    throws 
        java.io.IOException, CodingException
    {
        byte[] encodedReply = coder.getReplyCoder().encode(r);
        channel.write(ByteBuffer.wrap(encodedReply));
    }

    /*
     * handle()
     */
    private void handle (final SelectionKey key)
    {
        final long start = System.currentTimeMillis();

        SocketChannel channel = (SocketChannel)key.channel();

        if (log.isDebugEnabled())
        {
            log.debug
                ("handle() Incoming connection from "+
                 channel.socket().getInetAddress());
        }

        WorkItem wi = null;
        WorkItemCoder coder = null;
        ListenerReply reply = null;
        try
        {
            //final java.io.InputStream is = Channels.newInputStream(channel);
                //
                // doesn't work : non blocking problem

            final ChannelInputStream is = new ChannelInputStream(channel);

            final Object[] cl = determineCoderAndLength(is);

            coder = (WorkItemCoder)cl[0];
            final Integer iLength = (Integer)cl[1];

            if (iLength.intValue() > -1)
                is.setBytesToRead(iLength.intValue());

            wi = coder.decode(is, getContext(), getParams());

            if (log.isDebugEnabled())
            {
                log.debug
                    ("handle() received wi of class "+wi.getClass().getName());
            }

            //openwfe.org.Utils
            //    .dump("listener", (byte[])coder.encode(wi, null, null));

            //
            // consume wi

            final Object result = SocketListener.this.getConsumer().use(wi);

            reply = new OkReply(result);
        }
        catch (final Throwable t)
        {
            final Throwable rootCause = ExceptionUtils.getRootCause(t);

            reply = new FatalReply
                ("Fatal reply : "+rootCause.toString()+
                 " : "+rootCause.getMessage(), t);

            log.warn("handle() Fatal reply : "+t, t);
        }

        try
        {
            if (coder != null)
            {
                reply(coder, channel, reply);
            }
            else
            {
                log.warn("handle() cannot reply : no coder found !");
            }
        }
        catch (final Throwable t)
        {
            log.warn("handle() failed to reply to dispatcher", t);
        }

        //log.debug("handle() replied successfully");

        try
        {
            channel.close();
        }
        catch (final Throwable t)
        {
            log.warn("handle() Channel to dispatcher closed with an exception ?!?", t);
        }

        if (log.isDebugEnabled())
            log.debug("handle() took "+(System.currentTimeMillis() - start));
    }

}
