/*
 * Copyright (c) 2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: FileListener.java 2414 2006-03-10 22:15:03Z jmettraux $
 */

//
// OwfeHook.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.impl.listen;

import openwfe.org.OpenWfeException;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.listen.WorkItemConsumer;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.XmlCoderLoader;
import openwfe.org.engine.impl.listen.SocketListener;
import openwfe.org.engine.impl.dispatch.SocketDispatcher;


/**
 * A simple hook to add workitem listening capabilities to a Java application.
 * This hook uses a SocketListener to receive workitems from an OpenWFE engine.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author$
 * <br>$Id$ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class OwfeHook
{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(OwfeHook.class.getName());
    */

    //
    // CONSTANTS & co

    //
    // FIELDS

    private int listenPort = -1;
    private String engineHost = null;
    private int enginePort = -1;

    private ApplicationContext applicationContext = null;

    //
    // CONSTRUCTORS

    /**
     * Builds an OwfeHook
     *
     * @param listenPort on which port this hook shall listen
     * @param engineHost when treatment is over, the hostname of the machine
     * hosting the OpenWFE engine
     * @param enginePort the port on which the engine listens
     *
     * @exception ServiceException upon failing to set up the necessary
     * instances composing the hook
     */
    public OwfeHook
        (final int listenPort,
         final String engineHost,
         final int enginePort)
    throws 
        ServiceException
    {
        this.listenPort = listenPort;
        this.engineHost = engineHost;
        this.enginePort = enginePort;
        
        //
        // the application context
        
        this.applicationContext = new ApplicationContext();
        
        //
        // the socket listener
        
        final SocketListener sl = new SocketListener();
        final java.util.Map slParams = new java.util.HashMap();
        slParams.put("port", "7303");
        slParams.put("workItemConsumer", "consumer");
        sl.init("listener", this.applicationContext, slParams);
        
        this.applicationContext.add(sl); 
            //
            // it's a service, you can directly add it to the 
            // application context
        
        //
        // the coderLoader (a registry of available coders)
        //
        // (make sure to put the file coder-configuration.xml within the
        //  classpath of this code. You can usually find it at etc/engine/...)
        
        final XmlCoderLoader coderLoader = new XmlCoderLoader();
        final java.util.Map clParams = new java.util.HashMap(1);
        clParams.put(coderLoader.CONFIGURATION_FILE, "resource:/coder-configuration.xml");

        coderLoader.init
            (Definitions.S_WORKITEM_CODER_LOADER, 
             this.applicationContext, 
             clParams);
        
        this.applicationContext.add(coderLoader);
            //
            // it's a service
        
        //
        // the dispatcher points back to the workflow engine
        
        final SocketDispatcher dispatcher = new SocketDispatcher();
        final java.util.Map dParams = new java.util.HashMap();
        dParams.put("host", "engine.host.com");
        dParams.put("port", "7007");
        dParams.put("workItemCoder", "xmlCoder");
        dispatcher.init("dispatcher", this.applicationContext, dParams);
        
        //this.applicationContext.add(dispatcher);
            //
            // no need to bind the dispatcher as we reference it directly 
            // from the consumer's code.
        
        //
        // the workitem consumer (the code that reacts to incoming workitems)
        
        final WorkItemConsumer consumer = new WorkItemConsumer()
        {
            public Object use (WorkItem wi)
                throws OpenWfeException
            {
                OwfeHook.this.service(wi);

                dispatcher.dispatch(wi);
        
                return null;
            }
        };
        
        this.applicationContext.put("consumer", consumer);
            //
            // it's not a service (to keep the code smaller)
            // so let's put it in the application context as it is.
    }

    //
    // ABSTRACT METHODS

    /**
     * Implement this method in order to react upon incoming workitems.
     * You can manipulate the workitem. When the method terminates, the
     * OwfeHook will take care of replying to the engine (engineHost, 
     * enginePort) with the [modified] workitem.
     */
    public abstract void service (final WorkItem wi);

    //
    // METHODS

    /**
     * Returns the application context used internally by this hook.
     * Could be useful for some hook extensions / customizations.
     */
    public ApplicationContext getApplicationContext ()
    {
        return this.applicationContext;
    }

    //
    // STATIC METHODS

}
