/*
 * Copyright (c) 2005-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: SimpleProcessLibrary.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// SimpleProcessLibrary.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.impl.launch;

import openwfe.org.engine.launch.ProcessLibrary;


/**
 * This implementation of ProcessLibrary takes care of interpreting (launching)
 * the flows listed in its 'url' parameter ; having more than one 'url' 
 * parameter is possible.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: SimpleProcessLibrary.java 3087 2006-08-30 07:08:10Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class SimpleProcessLibrary

    extends LibraryService

    implements ProcessLibrary

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(SimpleProcessLibrary.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    private boolean loaded = false;

    //
    // CONSTRUCTORS

    //
    // METHODS from ProcessLibrary

    /**
     * Just tells the ProcessLibrary to load and interpret its library.
     * If the library already got loaded, nothing will occur.
     */
    public synchronized void load ()
    {
        if (loaded) return;

        log.debug("load()");

        loaded = true;
            //
            // do not fail at each load... only one attempt

        final Object o = this.getParams().get(P_URL);

        if (o instanceof String)
        {
            load((String)o);
        }
        else if (o instanceof java.util.List)
        {
            final java.util.Iterator it = ((java.util.List)o).iterator();
            while (it.hasNext())
            {
                load((String)it.next());
            }
        }
    }

    //
    // METHODS

    //
    // STATIC METHODS

}
