/*
 * Copyright (c) 2005-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: CronService.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// CronService.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.impl.launch;

import openwfe.org.FileUtils;
import openwfe.org.Application;
import openwfe.org.AbstractService;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;


/**
 * The cron service interprets at start time process definitions supposed to 
 * contain cron [tabs].
 * If such a file changed, it will get reloaded and 'rexecuted'. The files
 * to launch/interpret are listed through the 'url' parameter inherited
 * from the parent class LibraryService.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: CronService.java 3087 2006-08-30 07:08:10Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class CronService

    extends LibraryService

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(CronService.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    private java.util.TimerTask checkTask = null;
    private java.util.Map lastModificationTimes = new java.util.HashMap();

    //
    // CONSTRUCTORS

    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        super.init(serviceName, context, serviceParams);

        this.checkTask = new java.util.TimerTask()
        {
            public void run ()
            {
                try
                {
                    checkCrontab();
                }
                catch (final Throwable t)
                {
                    log.warn("checkTask : problem", t);
                }
            }
        };

        Application.getTimer().schedule
            (this.checkTask,
             1 * 60 * 1000,     // start after 1 mn
             1 * 60 * 1000);    // every minute

        log.info("init() '"+serviceName+"' ready.");
    }

    //
    // METHODS from Service

    public void stop ()
        throws ServiceException
    {
        super.stop();

        this.checkTask.cancel();
        log.info("stop() check daemon stopped.");

        log.info("stop() Service '"+getName()+"' stopped.");
    }

    //
    // METHODS

    /**
     * If necessary, reloads the cron process definitions.
     */
    protected synchronized void checkCrontab ()
    {
        //log.debug("checkCrontab()");

        final Object o = this.getParams().get(P_URL);

        java.util.List files = null;

        if (o instanceof java.util.List)
        {
            files = (java.util.List)o;
        }
        else
        {
            files = new java.util.ArrayList(1);
            files.add(o);
        }

        final java.util.Iterator it = files.iterator();
        while (it.hasNext())
        {
            check((String)it.next());
        }

        //log.debug("checkCrontab() over.");
    }

    /**
     * Determines if a cron process definition should be reloaded.
     */
    protected void check (final String url)
    {
        final String eUrl = FileUtils.expandUrl(url);

        final Long lm0 = (Long)this.lastModificationTimes.get(eUrl);
        final long lm1 = FileUtils.getLastModified(eUrl);

        if (lm0 == null || lm1 > lm0.longValue()) load(lm1, eUrl);
    }

    /**
     * Loads a cron process definition (and remembers its last modified
     * time).
     */
    protected void load (final long lastModified, final String url)
    {
        //log.debug("load() loading  "+url);

        this.lastModificationTimes.put(url, new Long(lastModified));

        this.load(url);
    }

    //
    // STATIC METHODS

}
