/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: TextHistory.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// TextHistory.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.impl.history;

import openwfe.org.MapUtils;
import openwfe.org.ApplicationContext;
import openwfe.org.ServiceException;
import openwfe.org.engine.history.History;
import openwfe.org.engine.history.HistoryIterator;
import openwfe.org.engine.history.HistoryException;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.expressions.FlowExpressionId;


/**
 * With this implementation of History, logging goes to plain text files.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 09:08:10 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: TextHistory.java 3087 2006-08-30 07:08:10Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class TextHistory

    extends AbstractHistory

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(TextHistory.class.getName());

    //
    // CONSTANTS (definitions)

    /**
     * Use the parameter 'fileName' to tell this service where it should
     * log the engine history.
     * By default, history will be stored under "./logs/history.log".
     */
    public final static String P_FILE_NAME = "fileName";

    //
    // FIELDS

    private java.io.PrintWriter out = null;

    //
    // CONSTRUCTORS

    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        super.init(serviceName, context, serviceParams);

        final String fileName = MapUtils.getAsString
            (getParams(), P_FILE_NAME, "logs/history.log");

        try
        {
            this.out = 
                new java.io.PrintWriter(new java.io.FileWriter(fileName));
        }
        catch (final Throwable t)
        {
            log.warn
                ("Failed to init history with file "+fileName, t);
        }
    }

    //
    // METHODS

    public void stop ()
        throws ServiceException
    {
        super.stop();

        //this.out.flush();
        this.out.close();

        log.info("'"+getName()+"' stopped.");
    }

    protected void doLog 
        (final FlowExpressionId fei, 
         final WorkItem wi,
         final String eventCode, 
         final String participantName,
         final String message)
    {
        StringBuffer sb = new StringBuffer();

        //long time = System.currentTimeMillis();
        //sb.append(time);
        
        sb.append(new java.util.Date(/*time*/));
        sb.append(" ");
        sb.append(eventCode);
        sb.append(" ");

        if (fei != null)
        {
            sb.append(fei.getEngineId());
            sb.append("::");
            sb.append(fei.getWorkflowDefinitionUrl());
            sb.append(" ");
            sb.append(fei.getWorkflowInstanceId());
            sb.append("   ");
            sb.append(fei.getExpressionId());
            sb.append(" ");
            sb.append(fei.getExpressionName());
            sb.append(" ");
        }

        if (participantName != null)
        {
            sb.append("'");
            sb.append(participantName);
            sb.append("'");
        }
        sb.append(" ");
        sb.append(message);

        //if (fei != null)
        //{
        //    sb.append(" -- ");
        //    sb.append(fei);
        //}

        this.out.println(sb);
        this.out.flush();
    }

    public HistoryIterator browse
        (String workflowName,
         String workflowRevision,
         long workflowInstanceId,
         long dateFrom,
         long dateto)
    throws
        HistoryException
    {
        throw new HistoryException("Not yet implemented.");
    }

}
