/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: AbstractHistory.java,v 1.14 2006/03/04 09:30:21 jmettraux Exp $
 */

//
// AbstractHistory.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.00 16.08.2003 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.impl.history;

import openwfe.org.MapUtils;
import openwfe.org.AbstractService;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.engine.history.History;
//import openwfe.org.engine.history.HistoryIterator;
//import openwfe.org.engine.history.HistoryException;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.expressions.FlowExpressionId;


/**
 * storing workitem tracing into a relational database
 * (this implementation only cares about participant apply/reply)
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: AbstractHistory.java,v 1.14 2006/03/04 09:30:21 jmettraux Exp $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class AbstractHistory

    extends AbstractService

    implements History

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(AbstractHistory.class.getName());

    //
    // CONSTANTS & co

    /**
     * Which is the lowest debug level this AbstractHistory instance should
     * log for ? Possible values are '-dbg', '-inf', '-war'.
     */
    public final static String P_LOG_LEVEL = "logLevel";

    /**
     * The default level of history logging is 'DEBUG'.
     */
    public final static String DEFAULT_LOG_LEVEL = EVT_DEBUG;

    //
    // FIELDS

    private String logLevel = null;

    //
    // CONSTRUCTORS

    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        super.init(serviceName, context, serviceParams);

        //
        // determine logging level
        
        this.logLevel = MapUtils.getAsString
            (serviceParams, P_LOG_LEVEL, DEFAULT_LOG_LEVEL);

        log.info("init() logLevel set to '"+this.logLevel+"'");
    }

    //
    // abstract methods

    /**
     * Where the actual logging job is done.
     */
    protected abstract void doLog
        (final FlowExpressionId fei, 
         final WorkItem wi,
         final String eventCode, 
         final String participantName,
         final String message);

    //
    // METHODS from History

    /**
     * This method filters out log messages of too low a level, it calls
     * doLog() for messages that are important enough to get logged.
     */
    public void log
        (final FlowExpressionId fei, 
         final WorkItem wi,
         final String eventCode, 
         final String participantName,
         final String message)
    {
        if (shouldNotLog(eventCode)) return;

        doLog(fei, wi, eventCode, participantName, message);
    }

    //
    // METHODS

    /**
     * This method enforces the log level, it's called by the log()
     * implementation found in this class.
     */
    protected boolean shouldNotLog (final String eventCode)
    {
        if (eventCode.startsWith("+")) return false;
            // always log '+' messages

        // debug, info or warn

        if (this.logLevel.equals(EVT_DEBUG)) return false;
        if (eventCode.equals(EVT_DEBUG)) return true;

        // info or warn

        if (this.logLevel.equals(EVT_INFO)) return false;
        //if (eventCode.equals(EVT_INFO)) return true;

        // warn

        return true;
    }

}
