/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: NumericFunctions.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// NumericFunctions.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.impl.functions;


import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.FlowExpression;


/**
 * Functions are static methods accepting a workitem and an array of string
 * are implemented here.
 * Functions about numbers are implemented here.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: NumericFunctions.java 3087 2006-08-30 07:08:10Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class NumericFunctions
{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(NumericFunctions.class.getName());

    //
    // CONSTANTS & co

    //
    // static methods (FUNCTIONS)

    /**
     * An alias function for 'sum'.
     */
    public static String add
        (final FlowExpression fe, final InFlowWorkItem wi, final String[] args)
    {
        if (args == null)
        {
            //log.debug("add() no args provided, returning '0'");

            return "0";
        }

        float result = 0;

        for (int i=0; i<args.length; i++)
        {
            //log.debug("add() args["+i+"] is >"+args[i]+"<");

            try
            {
                result += Float.parseFloat(args[i]);
                    //
                    // do not use 'double' : it yields strange results !!
            }
            catch (final NumberFormatException nfe)
            {
                // ignore
            }
        }

        return ""+result;
    }

    /**
     * The modulo function
     */
    public static String mod
        (final FlowExpression fe, final InFlowWorkItem wi, final String[] args)
    {
        if (args.length < 2) return "1.0";

        try
        {
            return 
                ""+(Float.parseFloat(args[0]) % Float.parseFloat(args[1]));
        }
        catch (final NumberFormatException nfe)
        {
            log.debug("mod() failure", nfe);
        }

        return "1.0";
    }

    /**
     * Returns the multiplication of all of the numeric values given as 'args'.
     */
    public static String mul
        (final FlowExpression fe, final InFlowWorkItem wi, final String[] args)
    {
        if (args == null)
        {
            //log.debug("mul() no args provided, returning '1'");

            return "1";
        }

        float result = 1.0f;

        for (int i=0; i<args.length; i++)
        {
            //log.debug("mul() args["+i+"] is >"+args[i]+"<");

            try
            {
                result = result * Float.parseFloat(args[i]);
            }
            catch (final NumberFormatException nfe)
            {
                // ignore
            }
        }

        return ""+result;
    }

    /**
     * Turns an incoming string to an int.
     */
    public static String toint
        (final FlowExpression fe, final InFlowWorkItem wi, final String[] args)
    {
        try
        {
            return ""+((int)Double.parseDouble(args[0]));
        }
        catch (final Throwable t)
        {
        }

        return "";
    }

    /**
     * Returns true if the first arg is a number.
     */
    public static String isnumeric
        (final FlowExpression fe, final InFlowWorkItem wi, final String[] args)
    {
        try
        {
            Double.parseDouble(args[0]);
            return BooleanFunctions.S_TRUE;
        }
        catch (final Throwable t)
        {
        }

        return BooleanFunctions.S_FALSE;
    }

    /**
     * Rounds the first arg (by considering it a double);
     * returns an error message if the rounding failed.
     */
    public static String round
        (final FlowExpression fe, final InFlowWorkItem wi, final String[] args)
    {
        try
        {
            return "" + Math.round(Double.parseDouble(args[0]));
        }
        catch (final Throwable t)
        {
            return "round failure : "+t;
        }
    }

    //
    // static methods

}
