/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: PerfExpressionPool.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// PerfExpressionPool.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.impl.expool;

import openwfe.org.engine.Definitions;
import openwfe.org.ApplicationContext;
import openwfe.org.ServiceException;
import openwfe.org.misc.Cache;
import openwfe.org.engine.misc.ThreadedStorer;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.history.History;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.expressions.InFlowObject;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.CompositeFlowExpression;
import openwfe.org.engine.participants.Participant;
import openwfe.org.engine.participants.ParticipantMap;


/**
 * Threaded and cached expression pool.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 09:08:10 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: PerfExpressionPool.java 3087 2006-08-30 07:08:10Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class PerfExpressionPool

    extends CachedExpressionPool

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(PerfExpressionPool.class.getName());

    //
    // INNER CLASSES

    //
    // CONSTANTS

    //
    // FIELDS

    private ThreadedStorer ts = null;

    //
    // CONSTRUCTORS

    public PerfExpressionPool ()
    {
        super();
    }

    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        super.init(serviceName, context, serviceParams);

        //
        // prepare threaded storage

        this.ts = new ThreadedStorer()
        {
            public InFlowObject doGet (final FlowExpressionId fei)
            {
                try
                {
                    return getStore().loadExpression(fei);
                }
                catch (final Throwable t)
                {
                    log.warn("doGet() failed to load "+fei, t);
                }
                return null;
            }

            public void doStore (final InFlowObject o)
                throws Exception
            {
                getStore().storeExpression((FlowExpression)o);
            }

            public void doRemove (final InFlowObject o)
                throws Exception
            {
                getStore().unstoreExpression((FlowExpression)o);
            }
        };
    }

    //
    // METHODS

    /**
     * Usually called by WorkflowInstanceBuilders to add a freshly created
     * expression to the pool.
     */
    public void add (final FlowExpression fe)
        throws PoolException
    {
        fe.setApplicationContext(getContext());

        getCache().put(fe.getId(), fe);

        this.ts.store(fe);
    }

    /**
     * Stores the flow expression (as it may have changed).
     */
    public void update (final FlowExpression fe)
        throws PoolException
    {
        getCache().put(fe.getId(), fe);

        this.ts.store(fe);
    }

    /**
     * Retrieves an expression from the pool.
     * If the expression cannot be retrieved from the pool, null will be
     * returned.
     */
    public FlowExpression fetch (final FlowExpressionId fei)
    {
        if (fei == null) return null;

        FlowExpression result = (FlowExpression)getCache().get(fei);

        if (result != null) return result;

        result = (FlowExpression)this.ts.get(fei);

        if (result != null) getCache().put(result.getId(), result);

        return result;
    }

    /**
     * Removes a flow expression :
     * - removes it from cache;
     * - removes it from store (disk or db)
     *
     * This method is called by the replyToFather method, as the
     * expression tree gets diminished.
     */
    public void removeExpression (final FlowExpression fe)
    {
        getCache().remove(fe.getId());

        this.ts.remove(fe);
    }

    //
    // STATUS

    /*
    public org.jdom.Element getStatus ()
    {
        org.jdom.Element result = super.getStatus();

        return result;
    }
    */

}
