/*
 * Copyright (c) 2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: AbstractExpressionStore.java 2717 2006-06-01 15:26:06Z jmettraux $
 */

//
// FailureStrategyNone.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.impl.expool;

import openwfe.org.engine.expool.FailureStrategy;
import openwfe.org.engine.workitem.InFlowWorkItem;
//import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.FlowExpressionId;


/**
 * This is the default implementation for a failure strategy; failed
 * workitems are simply discarded (like in previous versions of OpenWFE).
 *
 * <p><font size=2>CVS Info :
 * <br>$Author$
 * <br>$Id$ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class FailureStrategyNone

    implements FailureStrategy

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(FailureStrategyNone.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    //
    // CONSTRUCTORS

    /**
     * As a strategy is used by an expression pool, they share the same map
     * of initialization params.
     */
    public void init (final java.util.Map expoolParams)
    {
        // nothing to do.
    }

    //
    // METHODS

    /**
     * When intercepting an exception during a launch[sub] call the
     * expression pool will delegate to the strategy the handling of
     * the problem by calling this method.
     */
    public ApplyException failOnLauch
        (final ApplyException exception,
         final FlowExpressionId failPoint,
         final InFlowWorkItem wi)
    {
        return exception;
    }

    /**
     * Idem than failOnLaunch, but for apply failures.
     */
    public ApplyException failOnApply
        (final ApplyException exception,
         final FlowExpressionId failPoint,
         final InFlowWorkItem wi)
    {
        return exception;
    }

    //
    // STATIC METHODS

}
