/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: MailFormDispatcher.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// MailFormDispatcher.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.impl.dispatch;

import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.WorkItemCoder;
import openwfe.org.engine.impl.workitem.MailFormCoder;


/**
 * A mail form is a rather retro way of participant to a workflow : you 
 * receive an email containing the form you have to fill (after having hit 
 * reply).
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: MailFormDispatcher.java 3087 2006-08-30 07:08:10Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class MailFormDispatcher

    extends SmtpDispatcher

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(MailFormDispatcher.class.getName());

    //
    // CONSTANTS & co

    /**
     * This parameter 'monospace' may be set to 'true/yes/on' or to 
     * 'false/no/off/{not present}'.
     * When set to true, it means that the recipients MUA are of the type
     * pine or mutt (or at least use a monospace font).
     * Else, for a webmail tool, a different rendering will be used.
     * This parameter is used from within the MailFormCoder.
     */
    public final static String P_MONOSPACE
        = "monospace";

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // OVERRIDEN METHODS

    /**
     * Simply returns a new MailFormEncoder.
     */
    protected WorkItemCoder instantiateEncoder ()
    {
        return new MailFormCoder();

        // no need to init it...
    }

    /**
     * Determines the subject of the form email.
     */
    protected String determineSubject (final WorkItem wi)
    {
        String subject = wi.getAttributes().sget("mf_subject");
        if (subject != null) return subject;

        return "OpenWFE form";
    }

    /**
     * Ensuring that there is no workitem coder name inserted at the top
     * of the mail form, thus returning an empty string.
     */
    public String getWorkItemCoderName ()
    {
        return "";
    }

    //
    // METHODS

    //
    // STATIC METHODS

}
