/*
 * Copyright (c) 2006, John Mettraux, OpenWFE.org and Balazs Pataki.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: Definitions.java 2990 2006-08-06 20:23:49Z jmettraux $
 */

//
// HttpDispatcher.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.impl.dispatch;

import java.net.URLEncoder;

import openwfe.org.Utils;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.net.NetUtils;
import openwfe.org.engine.listen.reply.ListenerReply;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.WorkItemCoder;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.dispatch.AbstractWorkItemDispatcher;


/**
 * Dispatching workitem by POSTing them.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author$
 * <br>$Id$ </font>
 *
 * @author john.mettraux@openwfe.org
 * @author Balazs Pataki
 */
public class HttpDispatcher

    extends AbstractWorkItemDispatcher

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(HttpDispatcher.class.getName());

    //
    // CONSTANTS & co

    /**
     * Indicates where the workitem should get POSTed.
     */
    public final static String P_URL
        = "url";

    /**
     * When present, this 'formParamName' parameter indicates that
     * the encoded workitem should be displayed in the POSTed data as :
     *
     * field={...encoded_workitem...}
     * 
     * When not present, the encoded workitem will simply be outputted as
     * the body of the POST request.
     */
    public final static String P_FORM_PARAM_NAME
        = "formParamName";

    /**
     * (request property) 'encoder' with this parameter, the dispatcher
     * indicates to the listener (that one could care), the name of the
     * workitem encoder used.
     */
    public final static String RP_ENCODER
        = "Encoder";

    //
    // FIELDS

    private java.net.URL url = null;

    private String formParamName = null;

    //
    // CONSTRUCTORS

    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        super.init(serviceName, context, serviceParams);

        //
        // url

        final String sUrl = MapUtils.getMandatoryString(serviceParams, P_URL);

        if ( ! sUrl.startsWith("http://"))
            throw new ServiceException("cannot use non-HTTP URL '"+sUrl+"'");

        try
        {
            this.url = new java.net.URL(sUrl);
        }
        catch (final java.net.MalformedURLException e)
        {
            throw new ServiceException("cannot use URL '"+sUrl+"'", e);
        }

        log.info("init() url is "+sUrl);

        //
        // formParamName

        this.formParamName = 
            MapUtils.getAsString(serviceParams, P_FORM_PARAM_NAME);

        if (this.formParamName == null)
            //
            // keeping this version compatible with Balazs' patch
        {
            if (MapUtils.getAsBoolean(serviceParams, "sendAsForm", false))
                this.formParamName = "workItem";
        }

        if (this.formParamName != null)
            log.info("init() formParamName is '"+this.formParamName+"'");
    }

    //
    // METHODS form WorkItemDispatcher

    /**
     * Dispatches the workitem over a socket connection.
     */
    public Object dispatch (final WorkItem wi)
        throws DispatchingException
    {
        if (log.isDebugEnabled())
            log.debug("dispatch() to "+url);

        ListenerReply reply = null;

        java.net.URLConnection con = null;
        try
        {
            //
            // prepare connection

            con = this.url.openConnection();

            con.addRequestProperty(RP_ENCODER, getWorkItemCoderName());

            con.setDoOutput(true);

            //
            // prepare data (workitem)

            final byte[] encodedWorkitem = encodeWorkitem(wi);

            //
            // emit data

            final java.io.OutputStream os = con.getOutputStream();

            os.write(encodedWorkitem);

            os.flush();
            os.close();

            //
            // fetch reply

            reply = instantiateEncoder()
                .getReplyCoder().decode(con.getInputStream());
        }
        catch (final Throwable t)
        {
            throw new DispatchingException("dispatching failed", t);
        }
        /*
        finally
        {
        }
        */

        return handleReply(reply);
    }

    //
    // METHODS

    /**
     * Encoding the workitem, takes care of the 'formParamName' special case.
     */
    protected byte[] encodeWorkitem (final WorkItem wi)
        throws Exception
    {
        final byte[] bwi =
            (byte[])instantiateEncoder().encode(wi, getContext(), getParams());

        if (this.formParamName == null) return bwi;

        //
        // dealing with formParamName

        final StringBuffer sb = new StringBuffer();

        sb
            .append(this.formParamName)
            .append("=")
            .append(URLEncoder.encode(new String(bwi), Utils.getEncoding()));

        return sb.toString().getBytes(Utils.getEncoding());
    }

    /**
     * Returns the URL towards which this dispatcher will POST workitems.
     */
    public java.net.URL getUrl ()
    {
        return this.url;
    }

    //
    // STATIC METHODS

}
