/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: SyncExpression.java 3351 2006-09-19 01:02:20Z jmettraux $
 */

//
// SyncExpression.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.00 16.08.2003 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.expressions.sync;

import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.FlowExpressionId;


/**
 * Father of all SyncExpressions. SyncExpression implementations don't have
 * any clone method, they are instantiated at their client class apply time.<br>
 * <br>
 * <b>Beware</b> : a sync expression implementation should never keep track of 
 * its synchable expression (parent) in a read-write property (a field with a 
 * getter and a setter), it would give infinite loops at serialization time.<br>
 * Future releases of OpenWFE may perhaps include an XmlCoder with the ability
 * to break such loops...
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: SyncExpression.java 3351 2006-09-19 01:02:20Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public interface SyncExpression

    extends java.io.Serializable

{

    /** 
     * Prepares the syncExpression for usage (this method is called by
     * SyncUtils.determineSyncExpression()).
     * The 'children' list is used to keep track of highest and lowest
     * children (for the merge with those same names ('highest' and 'lowest')).
     */
    public void init 
        (SynchableExpression se, java.util.List children, InFlowWorkItem wi)
    throws 
        ApplyException;

    /**
     * Add child is an alternative to init (?), it will simply add the child
     * to the list of (perhaps) awaited children.
     * This method is called by Iterator instances when they work
     * with a SynchableExpression.
     */
    public void addChild (FlowExpressionId child);

    /**
     * Applies the given child. This task is delegated to the sync expression
     * where all the synchronization (as the name implies) takes place.
     */
    public void applyChild 
        (SynchableExpression se, FlowExpressionId child, InFlowWorkItem wi)
    throws 
        ApplyException;

    /**
     * The SynchableMethod using a SyncExpression will pass workitems that
     * get replied to it to the SyncExpression with this method.
     * It passed itself as well, so that the SyncExpression may use its
     * full decision power (and reply to the father of the SynchableExpression).
     */
    public void reply 
        (SynchableExpression se, InFlowWorkItem wi)
    throws 
        ReplyException;

    /* *
     * This method is called by the replaceChild method in the synchable
     * expression using the sync epxression implementation.
     * /
    public boolean replaceChild 
        (final FlowExpressionId thisFei, final FlowExpressionId thatFei);
     */

    /**
     * From the verb 'to ready' : readies the SyncExpression instance 
     * (eventually flushes its reply queue).
     */
    public void ready (SynchableExpression se)
        throws ReplyException;

    /**
     * Cancels all the pending children expression.
     */
    public void cancel (SynchableExpression se)
        throws ApplyException;

}
