/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ClassicalSyncExpression.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// ClassicalSyncExpression.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.00 16.08.2003 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.expressions.sync;

import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;


/**
 * Half an implementation of a ClassicalSyncExpression
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: ClassicalSyncExpression.java 3087 2006-08-30 07:08:10Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class ClassicalSyncExpression

    implements SyncExpression

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(ClassicalSyncExpression.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    private boolean syncOver = false;
    private java.util.List children = new java.util.ArrayList(10);

    //
    // CONSTRUCTORS

    /**
     * This method is called by SyncUtils.determineSyncExpression()
     */
    public void init
        (final SynchableExpression se, 
         final java.util.List children, 
         final InFlowWorkItem wi)
    {
        // nothing to do
    }

    //
    // BEAN METHODS

    /**
     * for when the sync expression gets serialized
     */
    public java.util.List getChildren()
    {
        return this.children;
    }

    /**
     * for when the sync expression gets deserialized
     */
    public void setChildren (final java.util.List l)
    {
        this.children = l;
    }

    /**
     * Returns true if meanwhile, the sync expression terminate the sync.
     */
    public boolean isSyncOver ()
    {
        return this.syncOver;
    }

    public void setSyncOver (final boolean b)
    {
        this.syncOver = b;
    }

    //
    // METHODS from SyncExpression

    public void addChild (final FlowExpressionId fei)
    {
        this.children.add(fei);
    }

}
