/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ExpressionMap.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// ExpressionMap.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.expressions.map;

import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.BuildException;


/**
 * Maps expressions as found in WFD to the corresponding classes
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 09:08:10 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: ExpressionMap.java 3087 2006-08-30 07:08:10Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public interface ExpressionMap
{

    /**
     * Returns the class associated with the name of the expression found
     * in the WFD
     */
    public Class getClass (String expressionName);

    /* *
     * Returns the params associated with the expression name. 
     * Might be interesting for storing images and custom treatment
     * class names.
     * /
    public java.util.Map getParams (String expressionName);
     */

    /**
     * A droflo method ; it returns the short expression name associated 
     * with an expression class. 
     */
    public String getName (Class expressionClass);

    /**
     * Returns a table of the names of the expression implementing/extending
     * the given expression class.
     */
    public String[] getNames (Class expressionClass);

    /**
     * A droflo method : returns the keys (the set of expression
     * names configured in this map)
     */
    public java.util.Set keySet ();

    /**
     * Since OpenWFE 1.4.8, raw expressions lies at the heart of how flows
     * are built (all was done before in the wfibuilder which vanished).
     */
    public Class getRawExpressionClass ();

    /**
     * Instantiates an empty expression; this method is used by droflo when
     * adding new expressions to a flow definition and of course by this class
     * resolveExpression() method, when parsing a flow.
     */
    public FlowExpression instantiateExpression (String expressionName)
        throws BuildException;

}
