/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: SequenceExpression.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// SequenceExpression.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

import openwfe.org.engine.Definitions;
import openwfe.org.engine.expool.ExpressionPool;
import openwfe.org.engine.workitem.InFlowWorkItem;


/**
 * Children are applied one by one and their result is not taken into account
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 09:08:10 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: SequenceExpression.java 3087 2006-08-30 07:08:10Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class SequenceExpression

    extends SequentialFlowExpression

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(SequenceExpression.class.getName());
    */

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    /*
     * debug override
     * /
    public void setParent (final FlowExpressionId fei) 
    { 
        log.debug("setParent() \n    for "+this.getId()+"\n    to "+fei);
        //openwfe.org.Utils.logStackTrace(log, "setParent()");

        super.setParent(fei);
    }
     */

    public void reply (final InFlowWorkItem wi)
        throws ReplyException
    {
        //
        // was it the last reply we were waiting for ?
        
        final int current = getChildren().indexOf(getCurrentId());

        /*
        if (log.isDebugEnabled())
        {
            log.debug("reply() this.id is         "+this.getId());
            log.debug("reply() current id    is   "+this.getCurrentId());
            log.debug("reply() current index is   "+current);
            log.debug("reply() children.size() is "+getChildren().size());
        }
        */

        if (current == getChildren().size()-1)
            //
            // this was the last one
        {
            //
            // reply to the father...

            //log.debug("reply() replying to parent");
            
            replyToParent(wi);
            return;
        }

        //
        // no, continue to apply children
        
        //log.debug("reply() resuming sequence");

        try
        {
            getExpressionPool().apply(this, wi);
        }
        catch (final ApplyException e)
        {
            throw new ReplyException
                ("Failed to apply next children expression "+getCurrentId(),
                 e);
        }

        /*
         * note that the wi, given by the sub-expression is given to the
         * next sub-expression...
         */
    }

}
