/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: OneChildExpression.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// OneChildExpression.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

import openwfe.org.ApplicationContext;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expool.ExpressionPool;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.raw.RawExpression;
import openwfe.org.engine.expressions.map.ExpressionMap;


/**
 * An expression that has exactly one child expression
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 09:08:10 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: OneChildExpression.java 3087 2006-08-30 07:08:10Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class OneChildExpression

    extends OneOrZeroChildExpression

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(OneChildExpression.class.getName());
    */

    //
    // FIELDS

    private FlowExpressionId childExpressionId = null;

    //
    // CONSTRUCTORS

    //
    // BEAN METHODS

    public FlowExpressionId getChildExpressionId () 
    { 
        return this.childExpressionId; 
    }

    public void setChildExpressionId (final FlowExpressionId fei) 
    { 
        this.childExpressionId = fei; 
    }

    //
    // OVERRIDEN METHODS

    public void initWorkflowInstanceId (final String workflowInstanceId)
    {
        super.initWorkflowInstanceId(workflowInstanceId);

        this.childExpressionId.setWorkflowInstanceId(workflowInstanceId);
    }

    /**
     * Overrides the init() from extended expressions : and makes sure
     * that the child gets set.
     */
    public void init 
        (final ApplicationContext context,
         final FlowExpressionId environmentId, 
         final FlowExpressionId parentId, 
         final FlowExpressionId id, 
         final RawExpression generatingExpression,
         final Object raw,
         final InFlowWorkItem currentWi)
    throws 
        BuildException
    {
        super.init
            (context, 
             environmentId,
             parentId,
             id,
             generatingExpression,
             raw,
             currentWi);

        //
        // taking care of the children

        java.util.List children = 
            generatingExpression.prepareChildren(currentWi);

        children = 
            generatingExpression.cleanChildren(children);

        if (children.size() > 0)
        {
            this.setChildExpressionId((FlowExpressionId)children.get(0));
        }

        /*
        if (children.size() > 1)
        {
            log.warn
                ("init() more than one children for "+id.getExpressionName()+
                 " "+id.getExpressionId());
        }
        */
    }

    //
    // METHODS

    public void apply (final InFlowWorkItem wi)
        throws ApplyException
    {
        if (this.childExpressionId == null) return;

        getExpressionPool().apply(this.childExpressionId, wi);
    }

    /**
     * Cancels itself and the child expression.
     */
    public InFlowWorkItem cancel ()
        throws ApplyException
    {
        final InFlowWorkItem wi =
            getExpressionPool().childCancel(this.childExpressionId);

        super.cancel();

        return wi;
    }

    /**
     * Remove this child (if the flow expression id corresponds).
     */
    public void removeChild (final FlowExpressionId fei)
    {
        if (this.childExpressionId == null) return;

        if (this.childExpressionId.equals(fei)) 
            this.childExpressionId = null;
    }

}
