/*
 * Copyright (c) 2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ForgetExpression.java 2668 2006-05-25 15:15:15Z jmettraux $
 */

//
// LoseExpression.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

import openwfe.org.Utils;
import openwfe.org.engine.workitem.InFlowWorkItem;


/**
 * Simply loses the children process tree, never replies, but may get cancelled
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-05-25 17:15:15 +0200 (Thu, 25 May 2006) $
 * <br>$Id: ForgetExpression.java 2668 2006-05-25 15:15:15Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class LoseExpression

    extends OneChildExpression

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(LoseExpression.class.getName());
    */

    //
    // CONSTANTS and co

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // OVERRIDEN METHODS

    /* *
     * Will trigger the child expression (if any) and immediately reply
     * to the parent expression (forgetting about the child).
     * /
    public void apply (final InFlowWorkItem wi)
        throws ApplyException
    {
        // simply applies its children...
    }
     */

    /**
     * The reply of the forget expression will do nothing.
     */
    public void reply (final InFlowWorkItem wi)
        throws ReplyException
    {
        // never replies to the parent
    }
    
    //
    // METHODS

}
