/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: LogExpression.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// LogExpression.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

import org.apache.log4j.Priority;

import openwfe.org.engine.history.History;
import openwfe.org.engine.workitem.InFlowWorkItem;


/**
 * A must have for debugging workflows : a 'log' expression.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: LogExpression.java 3087 2006-08-30 07:08:10Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class LogExpression

    extends ZeroChildExpression

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(LogExpression.class.getName());

    //
    // CONSTANTS & co

    private final static org.apache.log4j.Logger theLog = 
        org.apache.log4j.Logger.getLogger("openwfe.org.log");

    /**
     * The message to be logged has to be found in a 'message' attribute.
     */
    public final static String A_MESSAGE
        = "message";

    /**
     * The attribute 'level' may take the values 'debug', 'info' or 'warn',
     * by default it is set to 'info'.
     */
    public final static String A_LEVEL
        = "level";

    /**
     * If this 'engine-log' attribute is set to 'true', 'yes' or 'ok',
     * the log message will also appear in openwfe/logs/engine.log
     * (and have even more debug meaning)
     */
    public final static String A_TO_ENGINE_LOG
        = "engine-log";

    private final static String V_DBUG = "debug";
    private final static String V_INFO = "info";
    private final static String V_WARN = "warn";

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    public void apply (final InFlowWorkItem wi) 
        throws ApplyException
    {
        //log.debug("apply()");

        final String message = lookupAttribute(A_MESSAGE, wi);
        final String level = lookupAttribute(A_LEVEL, wi);
        final String sEngineLog = lookupAttribute(A_TO_ENGINE_LOG, wi);

        //
        // should also log to logs/engine.log ?

        final boolean engineLogToo = openwfe.org.Utils.toBoolean(sEngineLog);

        //
        // determine priority

        Priority priority = Priority.INFO;
        String eventCode = History.EVT_INFO;

        if (V_DBUG.equals(level))
        {
            priority = Priority.DEBUG;
            eventCode = History.EVT_DEBUG;
        }
        else if (V_WARN.equals(level))
        {
            priority = Priority.WARN;
            eventCode = History.EVT_WARN;
        }

        if (log.isDebugEnabled())
            log.debug("apply() message >"+message+"<");

        //
        // do log

        historyLog(wi, eventCode, null, message);

        if (engineLogToo) theLog.log(priority, message);

        //
        // done.
        
        applyToParent(wi);
            // this method is simply equivalent to 'replyToParent()' but it 
            // throws an ApplyException instead...
    }

    //
    // STATIC METHODS

}
