/*
 * Copyright (c) 2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id$
 */

//
// ListRotateExpression.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

import openwfe.org.Utils;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.ListAttribute;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.workitem.InFlowWorkItem;


/**
 * Turns a 'flat' field into a series of fiels or vice versa.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id$ </font>
 * <br>$Rev$ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class ListRotateExpression

    extends ZeroChildExpression

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(ListRotateExpression.class.getName());

    //
    // CONSTANTS & co

    /**
     * The name of the 'field' that contains the value to flatten or to
     * expand.
     */
    public final static String A_FIELD_NAME
        = "field";

    /**
     * If set, this parameter 'to-field' contains the name of the field
     * that will receive the result of the rotation.
     */
    public final static String A_TO_FIELD_NAME
        = "to-field";

    /**
     * The attribute 'separator' indicates which character should be used
     * to determine (or create) the separation of values for the rotation.
     */
    public final static String A_SEPARATOR
        = "separator";

    /**
     * If the attribute 'trim' is set to 'true' or 'yes', each element of
     * an 'expansion' (a rotation from horizontal to vertical) will be
     * trimmed. 
     * 'a, b, c' -&gt; 'a', 'b', 'c' instead of 'a', ' b', ' c'.
     */
    public final static String A_TRIM
        = "trim";

    /**
     * By default, the comma is the separator.
     */
    public final static String DEFAULT_SEPARATOR
        = ",";

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS from FlowExpression

    public void apply (final InFlowWorkItem wi)
        throws ApplyException
    {
        //
        // gather params

        final String fieldName = this.lookupAttribute(A_FIELD_NAME, wi);

        String separator = this.lookupAttribute(A_SEPARATOR, wi);
        if (separator == null) separator = DEFAULT_SEPARATOR;

        final String toFieldName = this.lookupAttribute(A_TO_FIELD_NAME, wi);

        final String sTrim = this.lookupAttribute(A_TRIM, wi);
        final boolean trim = Utils.toBoolean(sTrim);

        //
        // do the job

        final Attribute a = wi.getAttributes().getField(fieldName);

        if (a == null)
        {
            if (log.isDebugEnabled())
            {
                log.debug
                    ("apply() "+
                     "cannot perform rotation, no field named '"+fieldName+
                     "', continuing...");
            }
        }
        else
        {
            if (a instanceof ListAttribute)
            {
                flatten
                    (wi, 
                     fieldName, 
                     toFieldName, 
                     ((ListAttribute)a), 
                     separator, 
                     trim);
            }
            else
            {

                expand
                    (wi, 
                     fieldName, 
                     toFieldName, 
                     a, 
                     separator, 
                     trim);
            }
        }

        //
        // done

        applyToParent(wi);
    }

    //
    // METHODS

    private void flatten 
        (final InFlowWorkItem wi, 
         final String fieldName, 
         final String toFieldName, 
         final ListAttribute la,
         final String separator,
         final boolean trim)
    {
        StringBuffer sb = new StringBuffer();

        final java.util.Iterator it = la.iterator();
        while (it.hasNext())
        {
            final Attribute a = (Attribute)it.next();

            if (sb.length() > 0) sb.append(separator);

            sb.append(a.toString());
        }

        String fn = fieldName;
        if (toFieldName != null) fn = toFieldName;

        wi.getAttributes().puts(fn, sb.toString());

        if (log.isDebugEnabled())
            log.debug("flatten() '"+fn+"' -> '"+sb.toString()+"'");
    }

    private void expand
        (final InFlowWorkItem wi, 
         final String fieldName, 
         final String toFieldName, 
         final Attribute a,
         String separator,
         final boolean trim)
    {
        if (separator.equals("|")) separator = "\\|";
            //
            // there may be other special cases, but for now, it's sufficient

        //
        // do the job

        final String value = a.toString();

        final String[] ss = value.split(separator);

        final ListAttribute la = new ListAttribute(ss.length);

        for (int i=0; i<ss.length; i++)
        {
            String s = ss[i];
            if (trim) s = s.trim();

            la.add(new StringAttribute(s));

            if (log.isDebugEnabled())
                log.debug("expand() "+i+" -> '"+s+"'");
        }

        String fn = fieldName;
        if (toFieldName != null) fn = toFieldName;

        wi.getAttributes().put(fn, la);
    }

    //
    // STATIC METHODS

}
