/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: FlowExpression.java 3497 2006-10-17 08:26:33Z jmettraux $
 */

//
// FlowExpression.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

import openwfe.org.ApplicationContext;
import openwfe.org.engine.expool.ExpressionPool;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.raw.RawExpression;
import openwfe.org.engine.expressions.state.ExpressionState;


/**
 * The father of all expressions
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: FlowExpression.java 3497 2006-10-17 08:26:33Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public interface FlowExpression

    extends InFlowObject, Cloneable, java.io.Serializable

{

    //
    // CONSTANTS

    /* *
     * Prefix for 'behalf' variables.
     * /
    public final static String V_BEHALF
        = "onBehalfOf";
     */

    //
    // (abstract) GETTERS (and setters)

    /**
     * Returns the FlowExpressionId of the parent expression of this
     * expression.
     */
    public FlowExpressionId getParent ();

    /**
     * Returns the string representing the moment at which this expression
     * got applied (or null if it was not yet applied).
     */
    public String getApplyTime ();

    /**
     * Returns the attribute of this expression (they tune the behaviour
     * of the expression).
     */
    public java.util.Map getAttributes ();

    /**
     * Returns the environment to which this expression is bound
     */
    public FlowExpressionId getEnvironmentId ();


    public void setId (FlowExpressionId fei);
    public void setParent (FlowExpressionId fei);
    public void setAttributes (java.util.Map m);
    public void setEnvironmentId (FlowExpressionId fei);

    public void setApplicationContext (ApplicationContext ac);

    //
    // METHODS

    /**
     * For a regular expression, will be equivalent to getClass(), for
     * a RawExpression, will return the 'encapsulated' (non-compiled) 
     * expression class.
     */
    public Class getExpressionClass ();

    /**
     * Sets the workflowInstanceId of this expression (used when
     * initing a flow).
     * This method is usually overridden by expression with children
     * to propagate the new id to the children as well.
     */
    public void initWorkflowInstanceId (String workflowInstanceId);

    /**
     * Sets the lastExpressionId of the workItem as 'this' id
     */
    public void tag (InFlowWorkItem wi);

    /**
     * sets the apply time to now
     */
    public void touchApplyTime ();

    /**
     * Returns the number of milliseconds since this expression got applied
     * or null if it hasn't yet been applied.
     */
    public Long applyTimeAsLong ();

    /**
     * Returns the number of milliseconds elapsed since the expression
     * was applied
     */
    public long getTimeSinceApplied ();

    /**
     * This method returns the applicationContext currently attached to this 
     * FlowExpression.
     */
    public ApplicationContext context ();

    /**
     * The raw expressions use this method to init a 'real' expression.
     * As flows are lazily-initted, 'currentWi' is the incoming workitem that
     * triggered the initialization of the implementing expression.
     */
    public void init 
        (ApplicationContext context,
         FlowExpressionId envId,
         FlowExpressionId parentId, 
         FlowExpressionId id, 
         RawExpression generatingExpression,
         Object rawVersion,
         InFlowWorkItem currentWi)
    throws 
        BuildException;

    /**
     * Use this method when you want to ensure that the changes in the
     * fields of your expression will be kept, even if the expression
     * gets swapped to disk (to the ExpressionStore).
     * Expressions decide by themselves when they have to be stored.
     */
    public void storeItself ();

    /**
     * When the workflow is instantied, all expressions from root expression to
     * all leaf expressions see their 'apply' method get called.
     * When then leaf expressions (ParticipantExpressions) get answers from
     * their participant, they communicate the modified workitem to their
     * father expression with its 'reply' method.
     */
    public void apply (InFlowWorkItem wi)
        throws ApplyException;

    /**
     * For the vast majority of expressions, this is just an alias for apply(),
     * but for DefineExpression instances, it's very different.
     * This method is called by launchers upon starting a new [sub]flow.
     */
    public void launch (InFlowWorkItem wi)
        throws ApplyException;

    /**
     * When the workflow is instantied, all expressions from root expression to
     * all leaf expressions see their 'apply' method get called.
     * When then leaf expressions (ParticipantExpressions) get answers from
     * their participant, they communicate the modified workitem to their
     * father expression with its 'reply' method.
     */
    public void reply (InFlowWorkItem wi) 
        throws ReplyException;

    /**
     * Cancels an expression. It is especially important for composite 
     * expressions to pass the message to each of their children and for
     * participant expressions to send a CancelItem to their participant.<br>
     * If an workitem is returned, it means that the cancelled expression
     * was holding a workitem and that the expool (calling this method through
     * a state) should take care of resuming the flow.
     */
    public InFlowWorkItem cancel () 
        throws ApplyException;

    /**
     * replies to this FlowExpression parent
     */
    public void replyToParent (InFlowWorkItem wi)
        throws ReplyException;

    /**
     * A shortcut to fetch the expression pool from this application context
     */
    public ExpressionPool getExpressionPool ();

    /**
     * If an ExpressionState is present, the expression pool will use it
     * for any apply() or reply() instead of directly working with
     * the apply() and reply() of the expression.
     */
    public ExpressionState getState ();

    /**
     * Sets the ExpressionState of the FlowExpression (ie FrozenState, 
     * PausedState or null).
     */
    public void setState (ExpressionState es);

    /**
     * This class implements Cloneable...
     *
     * (I love this stuff : making it abstract to force
     * descendants to implement it !!)
     */
    public Object clone ();


    //
    // METHODS about variables and attributes

    /**
     * Sets a variable locally.
     */
    public void bindVariable (String variableName, Object value);

    /* *
     * Looks up a variable set in this expression, will return null if
     * no such variable is set here.
     * /
    public Object lookupLocalVariable (String variableName);
     */

    /**
     * Takes care of looking up a variable (locally or from the expression 
     * pool).
     */
    public Object lookupVariable (final String variableName);

    /**
     * Looks a process definition attribute ie in the example<br>
     * &lt;participant ref="toto" /&gt;<br>
     * lookupAttribute("ref");<br>
     * will return "toto".
     * If it were<br>
     * &lt;participant ref="toto_${index}" /&gt;<br>
     * and the variable "index" would be set to "2",<br>
     * lookupAttribute("ref");<br>
     * would have returned "toto_2".
     */
    public String lookupAttribute (String attributeName, InFlowWorkItem wi);

    /**
     * This method is used by the dump() method of the ExpressionPool.
     */
    public org.jdom.Element dump ();

}
