/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ExpressionWithTimeOut.java 3522 2006-10-30 00:56:28Z jmettraux $
 */

//
// ExpressionWithTimeOut.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.00 16.08.2003 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

import openwfe.org.time.Schedulable;


/**
 * This interface shall be implemented by every expression with a time out.
 * The purge daemon can determine if such expressions' timeOutReply() 
 * methods are to be called.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: ExpressionWithTimeOut.java 3522 2006-10-30 00:56:28Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public interface ExpressionWithTimeOut

    extends Schedulable

{

    //
    // CONSTANTS & co

    /**
     * This constant is used to fetch the timeout values in
     * the expression's attribute or elsewhere.
     */
    public final static String TIMEOUT
        = "timeout";

    /**
     * This is the timeout variable '__timeout__'.
     */
    public final static String V_TIMEOUT
        = "__timeout__";

    /**
     * A history tag for keeping track of expressions / flows that
     * timed out.
     */
    public final static String EVT_TIMED_OUT
        = "+TOU";

    /**
     * The timeout flag is used as the unique parameter to the trigger
     * method to indicate a 'timeout' order coming from the scheduler.
     * In the case of a 'when' expression, if the flag is not present
     * in the parameters of the trigger() method, it means the trigger
     * is a simple reschedule/recheck of the condition.
     */
    public final static String TIMEOUT_FLAG
        = "** TIMEOUT **";

    //
    // METHODS

    /**
     * Implementations of this method should return false when their
     * expression should not be the object of a timeout.
     */
    public boolean isTimeOutActivated ();

    /**
     * by implementing this method, expressions define how their
     * timeout is determined.
     * For example, the priority of the timeout setting for a
     * Participant expression is :<br>
     * <ol>
     *   <li>expression</li>
     *   <li>participant</li>
     *   <li>expressionPool</li>
     * </ol>
     * So this behaviour is implemented in ParticipantExpression's 
     * determineTimeOut method.<br>
     * <br>
     * Returning a timeout of -1 means 'no timeout'.
     */
    public Long determineTimeOut ();

    /* *
     * This method is called by the expression store purge daemon
     * on expressions that have timed out.
     * /
    public void timeOutReply ()
        throws ReplyException;
     */

    /* *
     * Returns the identifier under which the timeout got scheduled.
     * Returns null if no timeout was scheduled.
     * /
    public Long getTimeoutId ();
     */

}
