/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ExpoolDumpExpression.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// ExpoolDumpExpression.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

import openwfe.org.xml.XmlUtils;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.workitem.InFlowWorkItem;


/**
 * Dumps an image of the expression pool to a temp file.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: ExpoolDumpExpression.java 3087 2006-08-30 07:08:10Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class ExpoolDumpExpression

    extends ZeroChildExpression

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(ExpoolDumpExpression.class.getName());
    */

    //
    // CONSTANTS & co

    /**
     * The 'prefix' attribute is used to determine the dump files' name prefix.
     */
    public final static String A_PREFIX
        = "prefix";

    /**
     * The default prefix is 'expool'.
     */
    public final static String DEFAULT_PREFIX
        = "expool";

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS from FlowExpression

    public void apply (final InFlowWorkItem wi)
        throws ApplyException
    {
        String prefix = lookupAttribute(A_PREFIX, wi);

        if (prefix == null) prefix = DEFAULT_PREFIX;

        XmlUtils.dump(prefix, getExpressionPool().dump());

        //
        // resume flow

        applyToParent(wi);
    }

    //
    // METHODS

    //
    // STATIC METHODS

}
