/*
 * Copyright (c) 2005-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: EngineEnvironmentId.java 3448 2006-10-08 12:28:48Z jmettraux $
 */

//
// EngineEnvironmentId.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

import openwfe.org.engine.Definitions;


/**
 * This expression is a unique (singleton) expression pointing to the
 * Ur-Expression as stored in the expression pool of the engine.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: EngineEnvironmentId.java 3448 2006-10-08 12:28:48Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public final class EngineEnvironmentId

    extends FlowExpressionId

{

    //
    // CONSTANTS & co

    private final static String EE = "ee";

    /**
     * This singleton is used by the expression pool and its stores
     * to identify and store the Ur-Expression of the engine.
     */
    public final static FlowExpressionId ID
        = new EngineEnvironmentId();

    //
    // FIELDS

    //
    // CONSTRUCTORS

    /**
     * A public constructor is required (for the XmlCoder)
     */
    public EngineEnvironmentId ()
    {
        super();

        super.setOwfeVersion(Definitions.OPENWFE_VERSION);
        super.setEngineId(EE);
        super.setInitialEngineId(EE);
        super.setWorkflowDefinitionUrl(EE);
        super.setWorkflowDefinitionName(EE);
        super.setWorkflowDefinitionRevision(EE);
        super.setWorkflowInstanceId("");
        super.setExpressionName(Environment.EXPRESSION_NAME);
        super.setExpressionId("");
    }

    //
    // METHODS

    /*
    public final void setEngineId (String s) {}
    public final void setInitialEngineId (String s) {}
    public final void setWorkflowDefinitionUrl (String s) {}
    public final void setWorkflowDefinitionName (String s) {}
    public final void setWorkflowDefinitionRevision (String s) {}
    public final void setWorkflowInstanceId (String s) {}
    public final void setExpressionName (String s) {}
    public final void setExpressionId (String s) {}
    */

    //
    // STATIC METHODS

}
