/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ConcurrentIteratorExpression.java 3353 2006-09-20 00:55:38Z jmettraux $
 */

//
// ConcurrentIteratorExpression.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

import openwfe.org.OpenWfeException;
import openwfe.org.ApplicationContext;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.sync.SyncUtils;
import openwfe.org.engine.expressions.sync.SyncExpression;
import openwfe.org.engine.expressions.sync.SynchableExpression;


/**
 * A sequential iterator (exactly like a 'for' in java or c)
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-09-20 02:55:38 +0200 (Wed, 20 Sep 2006) $
 * <br>$Id: ConcurrentIteratorExpression.java 3353 2006-09-20 00:55:38Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class ConcurrentIteratorExpression

    extends OneChildExpression

    implements SynchableExpression

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(ConcurrentIteratorExpression.class.getName());
    */

    //
    // CONSTANTS & co

    //
    // FIELDS

    private Iterator iterator = null;
    private SyncExpression syncExpression = null;

    //
    // CONSTRUCTORS

    //
    // BEAN METHODS

    public Iterator getIterator () { return this.iterator; }

    public void setIterator (final Iterator i) { this.iterator = i; }

    //
    // METHODS from SynchableExpression

    public SyncExpression getSyncExpression ()
    {
        return this.syncExpression;
    }

    public void setSyncExpression (final SyncExpression syncExpression)
    {
        this.syncExpression = syncExpression;
    }

    //
    // METHODS from FlowExpression

    public void apply (final InFlowWorkItem wi) 
        throws ApplyException
    {
        //log.debug("apply() setting syncExpression");

        //
        // let's iterate (concurrently) !!!

        this.iterator = new Iterator(this, wi);

        this.setSyncExpression(SyncUtils.determineSyncExpression
            (this, null, wi));

        //log.debug
        //    ("apply() sync expression is of class "+
        //     this.syncExpression.getClass().getName());

        //this.storeItself();

        try
        {
            while (this.iterator.hasNext())
            {
                this.iterator.next(this, wi);
            }

            this.getSyncExpression().ready(this);
        }
        catch (final OpenWfeException owe)
        {
            throw new ApplyException
                ("Failed to iterate to first element", owe);
        }

        //this.storeItself();
            //
            // done in the sync expression
    }

    public void reply (final InFlowWorkItem wi)
        throws ReplyException
    {
        this.getSyncExpression().reply(this, wi);

        //this.storeItself();
            //
            // done in the sync expression
    }

    /**
     * Cancels all the launched subprocesses
     */
    public InFlowWorkItem cancel ()
        throws ApplyException
    {
        this.getSyncExpression().cancel(this);

        return super.cancel();
    }

    //
    // METHODS

}
