/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: BooleanCombinationExpression.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// BooleanCombinationExpression.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.BooleanAttribute;


/**
 * combines the boolean_value of two child expressions
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 09:08:10 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: BooleanCombinationExpression.java 3087 2006-08-30 07:08:10Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class BooleanCombinationExpression

    extends CleanCompositeFlowExpression

    implements BooleanExpression

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(BooleanCombinationExpression.class.getName());
    */

    //
    // FIELDS

    private int childCount = 0;
    private java.util.List booleanValues = new java.util.ArrayList(10);

    //
    // CONSTRUCTORS

    //
    // BEAN METHODS

    /**
     * This expression uses this childCount field to keep track of how
     * many boolean children have yet to reply.
     */
    public int getChildCount () 
    {
        return this.childCount;
    }

    /**
     * This expression lists the boolean reply values of its children here.
     */
    public java.util.List getBooleanValues ()
    {
        return this.booleanValues;
    }

    public void setChildCount (final int i)
    {
        this.childCount = i;
    }

    public void setBooleanValues (final java.util.List l)
    {
        this.booleanValues = l;
    }

    //
    // OVERRIDEN METHODS

    public void apply (final InFlowWorkItem wi) 
        throws ApplyException
    {
        this.childCount = getChildren().size();

        this.storeItself();

        //log.debug("apply() childCount is "+this.childCount);

        java.util.Iterator it = getChildren().iterator();
        while (it.hasNext())
        {
            final FlowExpressionId fei = (FlowExpressionId)it.next();

            getExpressionPool().apply(fei, wi);
        }
    }

    public void reply (final InFlowWorkItem wi)
        throws ReplyException
    {
        getBooleanValues()
            .add(new Boolean(ValueUtils.lookupBooleanResult(wi)));

        this.childCount--;

        //log.debug("reply() childCound is now "+this.childCount);

        //if (this.childCount > 0) return;
        if (this.childCount > 0)
        {
            this.storeItself();
            return;
        }

        //
        // combines the booleanValues 
        
        ValueUtils.setBooleanResult(wi, combineValues());

        replyToParent(wi);
    }

    //
    // ABSTRACT METHODS

    public abstract Boolean combineValues ();
    
    //
    // METHODS

}
