/*
 * Copyright (c) 2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: FailureStrategy.java 2846 2006-06-20 21:58:03Z jmettraux $
 */

//
// FailureStrategy.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.expool;

import openwfe.org.engine.workitem.InFlowWorkItem;
//import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.FlowExpressionId;


/**
 * A failure strategy implementation knows how to deal with apply() or
 * launch() failures within an expression pool.
 * The initial implementation is 
 * openwfe.org.engine.impl.expool.FailureStrategyNone, which basically, 
 * does nothing.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-06-20 23:58:03 +0200 (Tue, 20 Jun 2006) $
 * <br>$Id: FailureStrategy.java 2846 2006-06-20 21:58:03Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public interface FailureStrategy
{

    //
    // CONSTANTS

    //
    // METHODS

    /**
     * As a strategy is used by an expression pool, they share the same map
     * of initialization params.
     */
    public void init (final java.util.Map expoolParams);

    /**
     * When intercepting an exception during a launch[sub] call the
     * expression pool will delegate to the strategy the handling of
     * the problem by calling this method.
     */
    public ApplyException failOnLauch
        (ApplyException exception,
         FlowExpressionId failPoint,
         InFlowWorkItem wi);

    /**
     * Idem than failOnLaunch, but for apply failures.
     */
    public ApplyException failOnApply
        (ApplyException exception,
         FlowExpressionId failPoint,
         InFlowWorkItem wi);

}
