/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: DispatchingException.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// DispatchingException.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.dispatch;

import openwfe.org.OpenWfeException;
import openwfe.org.engine.listen.reply.WarningReply;


/**
 * Such an exception is thrown when a dispatcher fails to transmit a
 * workitem to a participant
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 09:08:10 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: DispatchingException.java 3087 2006-08-30 07:08:10Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class DispatchingException

    extends OpenWfeException

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(DispatchingException.class.getName());

    //
    // FIELDS

    private WarningReply reply = null;

    //
    // CONSTRUCTORS

    public DispatchingException (String message)
    {
        super(message);
    }

    public DispatchingException (String message, Throwable cause)
    {
        super(message, cause);
    }

    public DispatchingException (WarningReply reply)
    {
        super(reply.getMessage());
        this.reply = reply;

        if (log.isDebugEnabled())
        {
            log.debug("() Reply message is >"+reply.getMessage()+"<");
            log.debug("() Reply class is >"+reply.getClass().getName()+"<");
        }
    }

    //
    // METHODS

    //
    // the goal here is to ensure that stack trace printing
    // behaves like we want...
    //

    public WarningReply getReply ()
    {
        return this.reply;
    }

    public void printStackTrace ()
    {
        this.printStackTrace(System.out);
    }

    public void printStackTrace (java.io.PrintStream ps)
    {
        this.printStackTrace(new java.io.PrintWriter(ps));
    }

    public void printStackTrace (java.io.PrintWriter pw)
    {
        if (this.reply == null)
        {
            super.printStackTrace(pw);
            return;
        }

        pw.println(nullToSpace(this.reply.getMessage()));
        pw.println("Caused on listener side by :");
        pw.println(nullToSpace(this.reply.getExceptionMessage()));

        if (this.reply.getExceptionStackTrace() != null)
            pw.print(this.reply.getExceptionStackTrace());
    }

    private static String nullToSpace (String in)
    {
        if (in == null) return "";
        return in;
    }

    public String toString ()
    {
        StringBuffer sb = new StringBuffer();

        sb.append(this.getClass().getName());
        sb.append(" : ");
        sb.append(this.getMessage());

        if (this.reply != null)
        {
            sb.append(" ((");
            sb.append(this.reply.getClass().getName());
            sb.append(") ");
            sb.append(this.reply.getExceptionMessage());
            sb.append(")");
        }

        return sb.toString();
    }

    /*
    public String toString ()
    {
        StringBuffer sb = new StringBuffer();

        sb.append("-- ");
        sb.append(this.getClass().getName());
        sb.append(" --\n");

        sb.append("message   >"+getMessage()+"<\n");
        sb.append("cause     >"+getCause()+"<\n");
        sb.append("reply     >"+this.reply+"<\n");
        sb.append("reply.exceptionMessage    >"+this.reply.getExceptionMessage()+"<\n");
        sb.append("reply.exceptionStackTrace >"+this.reply.getExceptionStackTrace()+"<");

        return sb.toString();
    }
    */

}
