/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ControlSession.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// ControlSession.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.control;

import java.rmi.RemoteException;
import openwfe.org.engine.expressions.FlowExpressionId;


/**
 * The methods for engine administration
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: ControlSession.java 3087 2006-08-30 07:08:10Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public interface ControlSession

    extends java.rmi.Remote

{

    /**
     * Lists all the expressions currently in the expression pool of
     * the engine.
     */
    public java.util.List listExpressions ()
        throws ControlException, RemoteException;

    /**
     * If an expression is frozen (it's usually a participant expression that
     * failed to dispatch), this expression will attempt to unfreeze it.
     */
    public void unfreezeExpression (FlowExpressionId freezableExpressionId)
        throws ControlException, RemoteException;

    /*
    public void cancelFlow (FlowExpressionId fei)
        throws ControlException, RemoteException;
    */

    /**
     * Cancels a complete flow.
     */
    public void cancelFlow (String workflowInstanceId)
        throws ControlException, RemoteException;

    /**
     * Just cancels an expression (and its child expressions).
     */
    public void cancelExpression (FlowExpressionId fei)
        throws ControlException, RemoteException;

    /**
     * Completely freezes a flow.
     */
    public void freezeFlow (String workflowInstanceId)
        throws ControlException, RemoteException;

    /**
     * Just freezes an expression within a process instance (aka flow).
     */
    public void freezeExpression (FlowExpressionId freezableExpressionId)
        throws ControlException, RemoteException;

}
