/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.telemetry.tracing.runnable;

import org.opensearch.telemetry.tracing.ScopedSpan;
import org.opensearch.telemetry.tracing.SpanContext;
import org.opensearch.telemetry.tracing.SpanCreationContext;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.telemetry.tracing.attributes.Attributes;

public class TraceableRunnable
implements Runnable {
    private final Runnable runnable;
    private final SpanContext parent;
    private final Tracer tracer;
    private final String spanName;
    private final Attributes attributes;

    public TraceableRunnable(Tracer tracer, String spanName, SpanContext parent, Attributes attributes, Runnable runnable) {
        this.tracer = tracer;
        this.spanName = spanName;
        this.parent = parent;
        this.attributes = attributes;
        this.runnable = runnable;
    }

    @Override
    public void run() {
        try (ScopedSpan spanScope = this.tracer.startScopedSpan(new SpanCreationContext(this.spanName, this.attributes), this.parent);){
            this.runnable.run();
        }
    }
}

