/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;

public class PathEncoder {
    private static final String HTTP_CLIENT4_UTILS_CLASS = "org.apache.http.client.utils.URLEncodedUtils";
    private static final String HTTP_CLIENT5_UTILS_CLASS = "org.apache.hc.core5.net.URLEncodedUtils";
    private static final MethodHandle FORMAT_SEGMENTS_MH;

    public static String encode(String uri) {
        try {
            return FORMAT_SEGMENTS_MH.invoke(Collections.singletonList(uri), StandardCharsets.UTF_8).substring(1);
        }
        catch (Throwable ex) {
            throw new RuntimeException("Unable to encode URI: " + uri, ex);
        }
    }

    static {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(HTTP_CLIENT4_UTILS_CLASS);
        }
        catch (ClassNotFoundException ex) {
            try {
                clazz = Class.forName(HTTP_CLIENT5_UTILS_CLASS);
            }
            catch (ClassNotFoundException ex1) {
                clazz = null;
            }
        }
        if (clazz == null) {
            throw new IllegalStateException("Either 'org.apache.hc.core5.net.URLEncodedUtils' or 'org.apache.http.client.utils.URLEncodedUtils' is required by not found on classpath");
        }
        try {
            FORMAT_SEGMENTS_MH = MethodHandles.lookup().findStatic(clazz, "formatSegments", MethodType.methodType(String.class, Iterable.class, Charset.class));
        }
        catch (IllegalAccessException | NoSuchMethodException ex) {
            throw new IllegalStateException("Unable to find 'formatSegments' method in " + clazz + " class");
        }
    }
}

