/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest.geo_ip_stats;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class GeoIpDownloadStatistics
implements JsonpSerializable {
    private final int successfulDownloads;
    private final int failedDownloads;
    private final int totalDownloadTime;
    private final int databaseCount;
    private final int skippedUpdates;
    public static final JsonpDeserializer<GeoIpDownloadStatistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoIpDownloadStatistics::setupGeoIpDownloadStatisticsDeserializer);

    private GeoIpDownloadStatistics(Builder builder) {
        this.successfulDownloads = ApiTypeHelper.requireNonNull(builder.successfulDownloads, this, "successfulDownloads");
        this.failedDownloads = ApiTypeHelper.requireNonNull(builder.failedDownloads, this, "failedDownloads");
        this.totalDownloadTime = ApiTypeHelper.requireNonNull(builder.totalDownloadTime, this, "totalDownloadTime");
        this.databaseCount = ApiTypeHelper.requireNonNull(builder.databaseCount, this, "databaseCount");
        this.skippedUpdates = ApiTypeHelper.requireNonNull(builder.skippedUpdates, this, "skippedUpdates");
    }

    public static GeoIpDownloadStatistics of(Function<Builder, ObjectBuilder<GeoIpDownloadStatistics>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int successfulDownloads() {
        return this.successfulDownloads;
    }

    public final int failedDownloads() {
        return this.failedDownloads;
    }

    public final int totalDownloadTime() {
        return this.totalDownloadTime;
    }

    public final int databaseCount() {
        return this.databaseCount;
    }

    public final int skippedUpdates() {
        return this.skippedUpdates;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("successful_downloads");
        generator.write(this.successfulDownloads);
        generator.writeKey("failed_downloads");
        generator.write(this.failedDownloads);
        generator.writeKey("total_download_time");
        generator.write(this.totalDownloadTime);
        generator.writeKey("database_count");
        generator.write(this.databaseCount);
        generator.writeKey("skipped_updates");
        generator.write(this.skippedUpdates);
    }

    protected static void setupGeoIpDownloadStatisticsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::successfulDownloads, JsonpDeserializer.integerDeserializer(), "successful_downloads");
        op.add(Builder::failedDownloads, JsonpDeserializer.integerDeserializer(), "failed_downloads");
        op.add(Builder::totalDownloadTime, JsonpDeserializer.integerDeserializer(), "total_download_time");
        op.add(Builder::databaseCount, JsonpDeserializer.integerDeserializer(), "database_count");
        op.add(Builder::skippedUpdates, JsonpDeserializer.integerDeserializer(), "skipped_updates");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GeoIpDownloadStatistics> {
        private Integer successfulDownloads;
        private Integer failedDownloads;
        private Integer totalDownloadTime;
        private Integer databaseCount;
        private Integer skippedUpdates;

        public final Builder successfulDownloads(int value) {
            this.successfulDownloads = value;
            return this;
        }

        public final Builder failedDownloads(int value) {
            this.failedDownloads = value;
            return this;
        }

        public final Builder totalDownloadTime(int value) {
            this.totalDownloadTime = value;
            return this;
        }

        public final Builder databaseCount(int value) {
            this.databaseCount = value;
            return this;
        }

        public final Builder skippedUpdates(int value) {
            this.skippedUpdates = value;
            return this;
        }

        @Override
        public GeoIpDownloadStatistics build() {
            this._checkSingleUse();
            return new GeoIpDownloadStatistics(this);
        }
    }
}

