/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.geo_ip_stats.GeoIpDownloadStatistics;
import org.opensearch.client.opensearch.ingest.geo_ip_stats.GeoIpNodeDatabases;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class GeoIpStatsResponse
implements JsonpSerializable {
    private final GeoIpDownloadStatistics stats;
    private final Map<String, GeoIpNodeDatabases> nodes;
    public static final JsonpDeserializer<GeoIpStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoIpStatsResponse::setupGeoIpStatsResponseDeserializer);

    private GeoIpStatsResponse(Builder builder) {
        this.stats = ApiTypeHelper.requireNonNull(builder.stats, this, "stats");
        this.nodes = ApiTypeHelper.unmodifiableRequired(builder.nodes, (Object)this, "nodes");
    }

    public static GeoIpStatsResponse of(Function<Builder, ObjectBuilder<GeoIpStatsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final GeoIpDownloadStatistics stats() {
        return this.stats;
    }

    public final Map<String, GeoIpNodeDatabases> nodes() {
        return this.nodes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("stats");
        this.stats.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.nodes)) {
            generator.writeKey("nodes");
            generator.writeStartObject();
            for (Map.Entry<String, GeoIpNodeDatabases> item0 : this.nodes.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupGeoIpStatsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::stats, GeoIpDownloadStatistics._DESERIALIZER, "stats");
        op.add(Builder::nodes, JsonpDeserializer.stringMapDeserializer(GeoIpNodeDatabases._DESERIALIZER), "nodes");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GeoIpStatsResponse> {
        private GeoIpDownloadStatistics stats;
        private Map<String, GeoIpNodeDatabases> nodes;

        public final Builder stats(GeoIpDownloadStatistics value) {
            this.stats = value;
            return this;
        }

        public final Builder stats(Function<GeoIpDownloadStatistics.Builder, ObjectBuilder<GeoIpDownloadStatistics>> fn) {
            return this.stats(fn.apply(new GeoIpDownloadStatistics.Builder()).build());
        }

        public final Builder nodes(Map<String, GeoIpNodeDatabases> map) {
            this.nodes = Builder._mapPutAll(this.nodes, map);
            return this;
        }

        public final Builder nodes(String key, GeoIpNodeDatabases value) {
            this.nodes = Builder._mapPut(this.nodes, key, value);
            return this;
        }

        public final Builder nodes(String key, Function<GeoIpNodeDatabases.Builder, ObjectBuilder<GeoIpNodeDatabases>> fn) {
            return this.nodes(key, fn.apply(new GeoIpNodeDatabases.Builder()).build());
        }

        @Override
        public GeoIpStatsResponse build() {
            this._checkSingleUse();
            return new GeoIpStatsResponse(this);
        }
    }
}

