/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.UnionDeserializer;
import org.opensearch.client.opensearch._types.ErrorCause;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ErrorResponse
implements JsonpSerializable {
    private final ErrorCause error;
    private final Integer status;
    public static final JsonpDeserializer<ErrorResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ErrorResponse::setupErrorResponseDeserializer);

    private ErrorResponse(Builder builder) {
        this.error = ApiTypeHelper.requireNonNull(builder.error, this, "error");
        this.status = builder.status;
    }

    public static ErrorResponse of(Function<Builder, ObjectBuilder<ErrorResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final ErrorCause error() {
        return this.error;
    }

    public final Integer status() {
        return this.status;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("error");
        this.error.serialize(generator, mapper);
        if (this.status != null) {
            generator.writeKey("status");
            generator.write(this.status.intValue());
        }
    }

    protected static void setupErrorResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::error, ErrorResponse.buildErrorCauseDeserializers(), "error");
        op.add(Builder::status, JsonpDeserializer.integerDeserializer(), "status");
    }

    protected static JsonpDeserializer<ErrorCause> buildErrorCauseDeserializers() {
        return new UnionDeserializer.Builder<ErrorCause, Kind, Object>(ErrorResponse::getErrorCause, false).addMember(Kind.OBJECT, ErrorCause._DESERIALIZER).addMember(Kind.STRING, JsonpDeserializer.stringDeserializer()).build();
    }

    private static ErrorCause getErrorCause(Kind kind, Object errorCause) {
        return Kind.STRING.equals((Object)kind) ? ErrorCause.of((ErrorCause.Builder builder) -> builder.type("string_error").reason((String)errorCause)) : (ErrorCause)errorCause;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ErrorResponse> {
        private ErrorCause error;
        private Integer status;

        public final Builder error(ErrorCause value) {
            this.error = value;
            return this;
        }

        public final Builder error(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.error(fn.apply(new ErrorCause.Builder()).build());
        }

        public final Builder status(int value) {
            this.status = value;
            return this;
        }

        @Override
        public ErrorResponse build() {
            this._checkSingleUse();
            return new ErrorResponse(this);
        }
    }

    private static enum Kind {
        OBJECT,
        STRING;

    }
}

