/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.schema;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.opensaml.xml.parse.LoggingErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SchemaBuilder {
    private SchemaBuilder() {
    }

    public static Schema buildSchema(SchemaLanguage lang, String schemaFileOrDirectory) throws SAXException {
        if (schemaFileOrDirectory == null) {
            return null;
        }
        return SchemaBuilder.buildSchema(lang, new File(schemaFileOrDirectory));
    }

    public static Schema buildSchema(SchemaLanguage lang, String[] schemaFilesOrDirectories) throws SAXException {
        if (schemaFilesOrDirectories == null || schemaFilesOrDirectories.length == 0) {
            return null;
        }
        return SchemaBuilder.buildSchema(lang, schemaFilesOrDirectories);
    }

    public static Schema buildSchema(SchemaLanguage lang, File schemaFileOrDirectory) throws SAXException {
        if (schemaFileOrDirectory == null) {
            return null;
        }
        return SchemaBuilder.buildSchema(lang, new File[]{schemaFileOrDirectory});
    }

    public static Schema buildSchema(SchemaLanguage lang, File[] schemaFilesOrDirectories) throws SAXException {
        if (schemaFilesOrDirectories == null || schemaFilesOrDirectories.length == 0) {
            return null;
        }
        ArrayList<File> schemaFiles = new ArrayList<File>();
        SchemaBuilder.getSchemaFiles(lang, schemaFilesOrDirectories, schemaFiles);
        if (schemaFiles.isEmpty()) {
            return null;
        }
        ArrayList<StreamSource> schemaSources = new ArrayList<StreamSource>();
        for (File schemaFile : schemaFiles) {
            schemaSources.add(new StreamSource(schemaFile));
        }
        return SchemaBuilder.buildSchema(lang, schemaSources.toArray(new Source[0]));
    }

    public static Schema buildSchema(SchemaLanguage lang, InputStream schemaSource) throws SAXException {
        if (schemaSource == null) {
            return null;
        }
        return SchemaBuilder.buildSchema(lang, new StreamSource[]{new StreamSource(schemaSource)});
    }

    public static Schema buildSchema(SchemaLanguage lang, InputStream[] schemaSources) throws SAXException {
        if (schemaSources == null || schemaSources.length == 0) {
            return null;
        }
        ArrayList<StreamSource> sources = new ArrayList<StreamSource>();
        for (InputStream schemaSource : schemaSources) {
            if (schemaSource == null) continue;
            sources.add(new StreamSource(schemaSource));
        }
        if (sources.isEmpty()) {
            return null;
        }
        return SchemaBuilder.buildSchema(lang, sources.toArray(new Source[0]));
    }

    protected static void getSchemaFiles(SchemaLanguage lang, File[] schemaFilesOrDirectories, List<File> accumulatedSchemaFiles) {
        Logger log = SchemaBuilder.getLogger();
        if (lang == null) {
            throw new IllegalArgumentException("Schema language may not be null");
        }
        if (schemaFilesOrDirectories == null || schemaFilesOrDirectories.length == 0) {
            return;
        }
        for (File handle : schemaFilesOrDirectories) {
            if (handle == null) continue;
            if (!handle.canRead()) {
                log.debug("Ignoring '{}', no read permission", (Object)handle.getAbsolutePath());
            }
            if (handle.isFile() && handle.getName().endsWith(lang.getSchemaFileExtension())) {
                log.debug("Added schema source '{}'", (Object)handle.getAbsolutePath());
                accumulatedSchemaFiles.add(handle);
            }
            if (!handle.isDirectory()) continue;
            SchemaBuilder.getSchemaFiles(lang, handle.listFiles(), accumulatedSchemaFiles);
        }
    }

    protected static Schema buildSchema(SchemaLanguage lang, Source[] schemaSources) throws SAXException {
        if (lang == null) {
            throw new IllegalArgumentException("Schema language may not be null");
        }
        if (schemaSources == null) {
            throw new IllegalArgumentException("Schema sources may not be null");
        }
        SchemaFactory schemaFactory = lang == SchemaLanguage.XML ? SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema") : SchemaFactory.newInstance("http://relaxng.org/ns/structure/1.0");
        schemaFactory.setErrorHandler(new LoggingErrorHandler(LoggerFactory.getLogger(SchemaBuilder.class)));
        return schemaFactory.newSchema(schemaSources);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(SchemaBuilder.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SchemaLanguage {
        XML("xsd"),
        RELAX("rng");

        private String schemaFileExtension;

        private SchemaLanguage(String extension) {
            this.schemaFileExtension = extension;
        }

        public String getSchemaFileExtension() {
            return this.schemaFileExtension;
        }
    }
}

