/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Spliterators;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.NameCaseConvention;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.yaml.ReplaceAliasWithAnchorValueVisitor;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class DeleteProperty
extends Recipe {
    @Option(displayName="Property key", description="The key to be deleted.", example="management.metrics.binders.files.enabled")
    private final String propertyKey;
    @Deprecated
    @Option(displayName="Coalesce", description="(Deprecated: in a future version, this recipe will always use the `false` behavior) Simplify nested map hierarchies into their simplest dot separated property form.", required=false)
    @Nullable
    private final Boolean coalesce;
    @Option(displayName="Use relaxed binding", description="Whether to match the `propertyKey` using [relaxed binding](https://docs.spring.io/spring-boot/docs/2.5.6/reference/html/features.html#features.external-config.typesafe-configuration-properties.relaxed-binding) rules. Defaults to `true`. If you want to use exact matching in your search, set this to `false`.", required=false)
    @Nullable
    private final Boolean relaxedBinding;

    public String getDisplayName() {
        return "Delete property";
    }

    public String getDescription() {
        return "Delete a YAML property. Nested YAML mappings are interpreted as dot separated property names, i.e.  as Spring Boot interprets application.yml files like `a.b.c.d` or `a.b.c:d`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new YamlIsoVisitor<ExecutionContext>(){

            @Override
            public Yaml.Documents visitDocuments(Yaml.Documents documents, ExecutionContext executionContext) {
                if (documents != new ReplaceAliasWithAnchorValueVisitor().visit(documents, executionContext)) {
                    return documents;
                }
                return super.visitDocuments(documents, executionContext);
            }

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Yaml e = super.visitMappingEntry(entry, ctx);
                Deque propertyEntries = this.getCursor().getPathAsStream().filter(Yaml.Mapping.Entry.class::isInstance).map(Yaml.Mapping.Entry.class::cast).collect(Collectors.toCollection(ArrayDeque::new));
                String prop = StreamSupport.stream(Spliterators.spliteratorUnknownSize(propertyEntries.descendingIterator(), 0), false).map(e2 -> e2.getKey().getValue()).collect(Collectors.joining("."));
                if (!Boolean.FALSE.equals(DeleteProperty.this.relaxedBinding) ? NameCaseConvention.equalsRelaxedBinding((String)prop, (String)DeleteProperty.this.propertyKey) : prop.equals(DeleteProperty.this.propertyKey)) {
                    this.doAfterVisit(new DeletePropertyVisitor(entry));
                    if (Boolean.TRUE.equals(DeleteProperty.this.coalesce)) {
                        this.maybeCoalesceProperties();
                    }
                }
                return e;
            }
        };
    }

    private static boolean containsOnlyWhitespace(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public DeleteProperty(String propertyKey, @Nullable Boolean coalesce, @Nullable Boolean relaxedBinding) {
        this.propertyKey = propertyKey;
        this.coalesce = coalesce;
        this.relaxedBinding = relaxedBinding;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    @Deprecated
    @Nullable
    public Boolean getCoalesce() {
        return this.coalesce;
    }

    @Nullable
    public Boolean getRelaxedBinding() {
        return this.relaxedBinding;
    }

    @NonNull
    public String toString() {
        return "DeleteProperty(propertyKey=" + this.getPropertyKey() + ", coalesce=" + this.getCoalesce() + ", relaxedBinding=" + this.getRelaxedBinding() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteProperty)) {
            return false;
        }
        DeleteProperty other = (DeleteProperty)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$coalesce = this.getCoalesce();
        Boolean other$coalesce = other.getCoalesce();
        if (this$coalesce == null ? other$coalesce != null : !((Object)this$coalesce).equals(other$coalesce)) {
            return false;
        }
        Boolean this$relaxedBinding = this.getRelaxedBinding();
        Boolean other$relaxedBinding = other.getRelaxedBinding();
        if (this$relaxedBinding == null ? other$relaxedBinding != null : !((Object)this$relaxedBinding).equals(other$relaxedBinding)) {
            return false;
        }
        String this$propertyKey = this.getPropertyKey();
        String other$propertyKey = other.getPropertyKey();
        return !(this$propertyKey == null ? other$propertyKey != null : !this$propertyKey.equals(other$propertyKey));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DeleteProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $coalesce = this.getCoalesce();
        result = result * 59 + ($coalesce == null ? 43 : ((Object)$coalesce).hashCode());
        Boolean $relaxedBinding = this.getRelaxedBinding();
        result = result * 59 + ($relaxedBinding == null ? 43 : ((Object)$relaxedBinding).hashCode());
        String $propertyKey = this.getPropertyKey();
        result = result * 59 + ($propertyKey == null ? 43 : $propertyKey.hashCode());
        return result;
    }

    private static final class ToBeRemoved
    implements Marker {
        private final UUID id;

        static <Y2 extends Yaml> Y2 withMarker(Y2 y) {
            return (Y2)((Yaml)y.withMarkers(y.getMarkers().addIfAbsent((Marker)new ToBeRemoved(Tree.randomId()))));
        }

        static boolean hasMarker(Yaml y) {
            return y.getMarkers().findFirst(ToBeRemoved.class).isPresent();
        }

        public ToBeRemoved(UUID id) {
            this.id = id;
        }

        public UUID getId() {
            return this.id;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ToBeRemoved)) {
                return false;
            }
            ToBeRemoved other = (ToBeRemoved)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "DeleteProperty.ToBeRemoved(id=" + this.getId() + ")";
        }

        @NonNull
        public ToBeRemoved withId(UUID id) {
            return this.id == id ? this : new ToBeRemoved(id);
        }
    }

    private static class DeletePropertyVisitor<P>
    extends YamlVisitor<P> {
        private final Yaml.Mapping.Entry scope;

        private DeletePropertyVisitor(Yaml.Mapping.Entry scope) {
            this.scope = scope;
        }

        @Override
        public Yaml visitSequence(Yaml.Sequence sequence, P p) {
            sequence = (Yaml.Sequence)super.visitSequence(sequence, p);
            List entries = sequence.getEntries();
            return (entries = ListUtils.map(entries, entry -> ToBeRemoved.hasMarker(entry) ? null : entry)).isEmpty() ? ToBeRemoved.withMarker(sequence) : sequence.withEntries(entries);
        }

        @Override
        public Yaml visitSequenceEntry(Yaml.Sequence.Entry entry, P p) {
            Yaml.Mapping m;
            if ((entry = (Yaml.Sequence.Entry)super.visitSequenceEntry(entry, p)).getBlock() instanceof Yaml.Mapping && ToBeRemoved.hasMarker(m = (Yaml.Mapping)entry.getBlock())) {
                return ToBeRemoved.withMarker(entry);
            }
            return entry;
        }

        @Override
        public Yaml visitMapping(Yaml.Mapping mapping, P p) {
            Yaml.Mapping m = (Yaml.Mapping)super.visitMapping(mapping, p);
            boolean changed = false;
            ArrayList<Yaml.Mapping.Entry> entries = new ArrayList<Yaml.Mapping.Entry>();
            String deletedPrefix = null;
            int count = 0;
            for (Yaml.Mapping.Entry entry : m.getEntries()) {
                if (ToBeRemoved.hasMarker(entry.getValue())) {
                    changed = true;
                    continue;
                }
                if (entry == this.scope || entry.getValue() instanceof Yaml.Mapping && ((Yaml.Mapping)entry.getValue()).getEntries().isEmpty()) {
                    deletedPrefix = entry.getPrefix();
                    changed = true;
                    continue;
                }
                if (deletedPrefix != null) {
                    if (count == 0 && DeleteProperty.containsOnlyWhitespace(entry.getPrefix())) {
                        entry = entry.withPrefix(deletedPrefix);
                    }
                    deletedPrefix = null;
                }
                entries.add(entry);
                ++count;
            }
            if (changed) {
                Yaml.Document document;
                m = m.withEntries(entries);
                if (entries.isEmpty()) {
                    m = ToBeRemoved.withMarker(m);
                }
                if (this.getCursor().getParentOrThrow().getValue() instanceof Yaml.Document && !(document = (Yaml.Document)this.getCursor().getParentOrThrow().getValue()).isExplicit()) {
                    m = m.withEntries(m.getEntries());
                }
            }
            return m;
        }
    }
}

