/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.CoalescePropertiesVisitor;
import org.openrewrite.yaml.cleanup.RemoveUnusedVisitor;
import org.openrewrite.yaml.format.AutoFormatVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class YamlVisitor<P>
extends TreeVisitor<Yaml, P> {
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof Yaml.Documents;
    }

    public String getLanguage() {
        return "yaml";
    }

    public <Y2 extends Yaml> Y2 maybeAutoFormat(Y2 before, Y2 after, P p) {
        return this.maybeAutoFormat(before, after, p, this.getCursor());
    }

    public <Y2 extends Yaml> Y2 maybeAutoFormat(Y2 before, Y2 after, P p, Cursor cursor) {
        return this.maybeAutoFormat(before, after, null, p, cursor);
    }

    public <Y2 extends Yaml> Y2 maybeAutoFormat(Y2 before, Y2 after, @Nullable Yaml stopAfter, P p, Cursor cursor) {
        if (before != after) {
            return (Y2)new AutoFormatVisitor(stopAfter).visit((Tree)after, (Object)p, cursor);
        }
        return after;
    }

    public <Y2 extends Yaml> Y2 autoFormat(Y2 y, P p) {
        return this.autoFormat(y, p, this.getCursor());
    }

    public <Y2 extends Yaml> Y2 autoFormat(Y2 y, P p, Cursor cursor) {
        return this.autoFormat(y, null, p, cursor);
    }

    public <Y2 extends Yaml> Y2 autoFormat(Y2 y, @Nullable Yaml stopAfter, P p, Cursor cursor) {
        return (Y2)new AutoFormatVisitor(stopAfter).visit((Tree)y, (Object)p, cursor);
    }

    public Yaml visitDocuments(Yaml.Documents documents, P p) {
        return documents.withDocuments(ListUtils.map(documents.getDocuments(), d -> (Yaml.Document)this.visitAndCast((Tree)d, p))).withMarkers(this.visitMarkers(documents.getMarkers(), p));
    }

    public Yaml visitDocument(Yaml.Document document, P p) {
        return document.withBlock((Yaml.Block)this.visit(document.getBlock(), p)).withMarkers(this.visitMarkers(document.getMarkers(), p));
    }

    public Yaml visitMapping(Yaml.Mapping mapping, P p) {
        return mapping.withEntries(ListUtils.map(mapping.getEntries(), e -> (Yaml.Mapping.Entry)this.visitAndCast((Tree)e, p))).withMarkers(this.visitMarkers(mapping.getMarkers(), p));
    }

    public Yaml visitMappingEntry(Yaml.Mapping.Entry entry, P p) {
        Yaml.Mapping.Entry e = entry;
        e = e.withKey((Yaml.Scalar)this.visitAndCast(e.getKey(), p));
        e = e.withValue((Yaml.Block)this.visitAndCast(e.getValue(), p));
        return e.withMarkers(this.visitMarkers(e.getMarkers(), p));
    }

    public Yaml visitScalar(Yaml.Scalar scalar, P p) {
        return scalar.withAnchor((Yaml.Anchor)this.visitAndCast(scalar.getAnchor(), p)).withMarkers(this.visitMarkers(scalar.getMarkers(), p));
    }

    public Yaml visitSequence(Yaml.Sequence sequence, P p) {
        return sequence.withEntries(ListUtils.map(sequence.getEntries(), e -> (Yaml.Sequence.Entry)this.visitAndCast((Tree)e, p))).withMarkers(this.visitMarkers(sequence.getMarkers(), p));
    }

    public Yaml visitSequenceEntry(Yaml.Sequence.Entry entry, P p) {
        return entry.withBlock((Yaml.Block)this.visitAndCast(entry.getBlock(), p)).withMarkers(this.visitMarkers(entry.getMarkers(), p));
    }

    public Yaml visitAnchor(Yaml.Anchor anchor, P p) {
        return anchor.withMarkers(this.visitMarkers(anchor.getMarkers(), p));
    }

    public Yaml visitAlias(Yaml.Alias alias, P p) {
        return alias.withAnchor((Yaml.Anchor)this.visitAndCast(alias.getAnchor(), p)).withMarkers(this.visitMarkers(alias.getMarkers(), p));
    }

    public void maybeCoalesceProperties() {
        if (this.getAfterVisit().stream().noneMatch(CoalescePropertiesVisitor.class::isInstance)) {
            this.doAfterVisit(new CoalescePropertiesVisitor());
        }
    }

    public void removeUnused(@Nullable Cursor cursorParent) {
        if (this.getAfterVisit().stream().noneMatch(RemoveUnusedVisitor.class::isInstance)) {
            this.doAfterVisit(new RemoveUnusedVisitor(cursorParent));
        }
    }
}

