/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.toml.tree;

import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Markers;
import org.openrewrite.toml.TomlVisitor;
import org.openrewrite.toml.internal.TomlPrinter;
import org.openrewrite.toml.tree.Space;
import org.openrewrite.toml.tree.TomlKey;
import org.openrewrite.toml.tree.TomlRightPadded;
import org.openrewrite.toml.tree.TomlType;
import org.openrewrite.toml.tree.TomlValue;

public interface Toml
extends Tree {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)this.acceptToml((TomlVisitor)v.adapt(TomlVisitor.class), p);
    }

    default public <P> @Nullable Toml acceptToml(TomlVisitor<P> v, P p) {
        return (Toml)v.defaultValue(this, p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(TomlVisitor.class);
    }

    public Space getPrefix();

    public <J extends Toml> J withPrefix(Space var1);

    public static final class Table
    implements TomlValue {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final @Nullable TomlRightPadded<Identifier> name;
        private final List<TomlRightPadded<Toml>> values;

        public @Nullable Identifier getName() {
            return this.name != null ? this.name.getElement() : null;
        }

        public Table withName(@Nullable Identifier name) {
            return this.getPadding().withName(TomlRightPadded.withElement(this.name, name));
        }

        public List<Toml> getValues() {
            return TomlRightPadded.getElements(this.values);
        }

        public Table withValues(List<Toml> values) {
            return this.getPadding().withValues(TomlRightPadded.withElements(this.values, values));
        }

        @Override
        public <P> Toml acceptToml(TomlVisitor<P> v, P p) {
            return v.visitTable(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Toml.Table(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", values=" + this.getValues() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Table)) {
                return false;
            }
            Table other = (Table)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Table(UUID id, Space prefix, Markers markers, @Nullable TomlRightPadded<Identifier> name, List<TomlRightPadded<Toml>> values) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.values = values;
        }

        @Generated
        private Table(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable TomlRightPadded<Identifier> name, List<TomlRightPadded<Toml>> values) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.values = values;
        }

        @NonNull
        @Generated
        public Table withId(UUID id) {
            return this.id == id ? this : new Table(this.padding, id, this.prefix, this.markers, this.name, this.values);
        }

        @NonNull
        @Generated
        public Table withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Table(this.padding, this.id, prefix, this.markers, this.name, this.values);
        }

        @NonNull
        @Generated
        public Table withMarkers(Markers markers) {
            return this.markers == markers ? this : new Table(this.padding, this.id, this.prefix, markers, this.name, this.values);
        }

        public static class Padding {
            private final Table t;

            public List<TomlRightPadded<Toml>> getValues() {
                return this.t.values;
            }

            public Table withValues(List<TomlRightPadded<Toml>> values) {
                return this.t.values == values ? this.t : new Table(this.t.id, this.t.prefix, this.t.markers, this.t.name, values);
            }

            public @Nullable TomlRightPadded<Identifier> getName() {
                return this.t.name;
            }

            public Table withName(@Nullable TomlRightPadded<Identifier> name) {
                return this.t.name == name ? this.t : new Table(this.t.id, this.t.prefix, this.t.markers, name, this.t.values);
            }

            @Generated
            public Padding(Table t) {
                this.t = t;
            }
        }
    }

    public static final class Literal
    implements Toml {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final TomlType.Primitive type;
        private final String source;
        private final Object value;

        @Override
        public <P> Toml acceptToml(TomlVisitor<P> v, P p) {
            return v.visitLiteral(this, p);
        }

        public String toString() {
            return "Literal{prefix=" + this.prefix + ", source=" + this.source + "}";
        }

        @Generated
        public Literal(UUID id, Space prefix, Markers markers, TomlType.Primitive type, String source, Object value) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.type = type;
            this.source = source;
            this.value = value;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public TomlType.Primitive getType() {
            return this.type;
        }

        @Generated
        public String getSource() {
            return this.source;
        }

        @Generated
        public Object getValue() {
            return this.value;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Literal)) {
                return false;
            }
            Literal other = (Literal)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Literal withId(UUID id) {
            return this.id == id ? this : new Literal(id, this.prefix, this.markers, this.type, this.source, this.value);
        }

        @NonNull
        @Generated
        public Literal withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Literal(this.id, prefix, this.markers, this.type, this.source, this.value);
        }

        @NonNull
        @Generated
        public Literal withMarkers(Markers markers) {
            return this.markers == markers ? this : new Literal(this.id, this.prefix, markers, this.type, this.source, this.value);
        }

        @NonNull
        @Generated
        public Literal withType(TomlType.Primitive type) {
            return this.type == type ? this : new Literal(this.id, this.prefix, this.markers, type, this.source, this.value);
        }

        @NonNull
        @Generated
        public Literal withSource(String source) {
            return this.source == source ? this : new Literal(this.id, this.prefix, this.markers, this.type, source, this.value);
        }

        @NonNull
        @Generated
        public Literal withValue(Object value) {
            return this.value == value ? this : new Literal(this.id, this.prefix, this.markers, this.type, this.source, value);
        }
    }

    public static final class KeyValue
    implements TomlValue {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final TomlRightPadded<TomlKey> key;
        private final Toml value;

        public TomlKey getKey() {
            return this.key.getElement();
        }

        public KeyValue withKey(TomlKey key) {
            return this.getPadding().withKey(TomlRightPadded.withElement(this.key, key));
        }

        @Override
        public <P> Toml acceptToml(TomlVisitor<P> v, P p) {
            return v.visitKeyValue(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return "KeyValue{prefix=" + this.prefix + ", key=" + this.key.getElement() + '}';
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Toml getValue() {
            return this.value;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeyValue)) {
                return false;
            }
            KeyValue other = (KeyValue)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public KeyValue(UUID id, Space prefix, Markers markers, TomlRightPadded<TomlKey> key, Toml value) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.key = key;
            this.value = value;
        }

        @Generated
        private KeyValue(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, TomlRightPadded<TomlKey> key, Toml value) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.key = key;
            this.value = value;
        }

        @NonNull
        @Generated
        public KeyValue withPadding(@Nullable WeakReference<Padding> padding) {
            return this.padding == padding ? this : new KeyValue(padding, this.id, this.prefix, this.markers, this.key, this.value);
        }

        @NonNull
        @Generated
        public KeyValue withId(UUID id) {
            return this.id == id ? this : new KeyValue(this.padding, id, this.prefix, this.markers, this.key, this.value);
        }

        @NonNull
        @Generated
        public KeyValue withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new KeyValue(this.padding, this.id, prefix, this.markers, this.key, this.value);
        }

        @NonNull
        @Generated
        public KeyValue withMarkers(Markers markers) {
            return this.markers == markers ? this : new KeyValue(this.padding, this.id, this.prefix, markers, this.key, this.value);
        }

        @NonNull
        @Generated
        public KeyValue withValue(Toml value) {
            return this.value == value ? this : new KeyValue(this.padding, this.id, this.prefix, this.markers, this.key, value);
        }

        public static class Padding {
            private final KeyValue t;

            public TomlRightPadded<TomlKey> getKey() {
                return this.t.key;
            }

            public KeyValue withKey(TomlRightPadded<TomlKey> key) {
                return this.t.key == key ? this.t : new KeyValue(this.t.id, this.t.prefix, this.t.markers, key, this.t.value);
            }

            @Generated
            public Padding(KeyValue t) {
                this.t = t;
            }
        }
    }

    public static final class Identifier
    implements TomlKey {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final String source;
        private final String name;

        @Override
        public <P> Toml acceptToml(TomlVisitor<P> v, P p) {
            return v.visitIdentifier(this, p);
        }

        public String toString() {
            return "Identifier{prefix=" + this.prefix + ", name=" + this.name + "}";
        }

        @Generated
        public Identifier(UUID id, Space prefix, Markers markers, String source, String name) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.source = source;
            this.name = name;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public String getSource() {
            return this.source;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Identifier)) {
                return false;
            }
            Identifier other = (Identifier)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Identifier withId(UUID id) {
            return this.id == id ? this : new Identifier(id, this.prefix, this.markers, this.source, this.name);
        }

        @NonNull
        @Generated
        public Identifier withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Identifier(this.id, prefix, this.markers, this.source, this.name);
        }

        @NonNull
        @Generated
        public Identifier withMarkers(Markers markers) {
            return this.markers == markers ? this : new Identifier(this.id, this.prefix, markers, this.source, this.name);
        }

        @NonNull
        @Generated
        public Identifier withSource(String source) {
            return this.source == source ? this : new Identifier(this.id, this.prefix, this.markers, source, this.name);
        }

        @NonNull
        @Generated
        public Identifier withName(String name) {
            return this.name == name ? this : new Identifier(this.id, this.prefix, this.markers, this.source, name);
        }
    }

    public static final class Empty
    implements Toml {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;

        @Override
        public <P> Toml acceptToml(TomlVisitor<P> v, P p) {
            return v.visitEmpty(this, p);
        }

        @Generated
        public Empty(UUID id, Space prefix, Markers markers) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Toml.Empty(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Empty)) {
                return false;
            }
            Empty other = (Empty)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Empty withId(UUID id) {
            return this.id == id ? this : new Empty(id, this.prefix, this.markers);
        }

        @NonNull
        @Generated
        public Empty withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Empty(this.id, prefix, this.markers);
        }

        @NonNull
        @Generated
        public Empty withMarkers(Markers markers) {
            return this.markers == markers ? this : new Empty(this.id, this.prefix, markers);
        }
    }

    public static final class Document
    implements Toml,
    SourceFile {
        private final UUID id;
        private final Path sourcePath;
        private final Space prefix;
        private final Markers markers;
        private final String charsetName;
        private final boolean charsetBomMarked;
        private final @Nullable Checksum checksum;
        private final @Nullable FileAttributes fileAttributes;
        private final List<TomlValue> values;
        private final Space eof;

        public Charset getCharset() {
            return Charset.forName(this.charsetName);
        }

        public Document withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        @Override
        public <P> Toml acceptToml(TomlVisitor<P> v, P p) {
            return v.visitDocument(this, p);
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new TomlPrinter();
        }

        @Generated
        public Document(UUID id, Path sourcePath, Space prefix, Markers markers, String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, @Nullable FileAttributes fileAttributes, List<TomlValue> values, Space eof) {
            this.id = id;
            this.sourcePath = sourcePath;
            this.prefix = prefix;
            this.markers = markers;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.fileAttributes = fileAttributes;
            this.values = values;
            this.eof = eof;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Path getSourcePath() {
            return this.sourcePath;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public String getCharsetName() {
            return this.charsetName;
        }

        @Generated
        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        @Generated
        public @Nullable Checksum getChecksum() {
            return this.checksum;
        }

        @Generated
        public @Nullable FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        @Generated
        public List<TomlValue> getValues() {
            return this.values;
        }

        @Generated
        public Space getEof() {
            return this.eof;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Toml.Document(id=" + this.getId() + ", sourcePath=" + this.getSourcePath() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", charsetName=" + this.getCharsetName() + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", checksum=" + this.getChecksum() + ", fileAttributes=" + this.getFileAttributes() + ", values=" + this.getValues() + ", eof=" + this.getEof() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Document)) {
                return false;
            }
            Document other = (Document)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Document withId(UUID id) {
            return this.id == id ? this : new Document(id, this.sourcePath, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.values, this.eof);
        }

        @NonNull
        @Generated
        public Document withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new Document(this.id, sourcePath, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.values, this.eof);
        }

        @NonNull
        @Generated
        public Document withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Document(this.id, this.sourcePath, prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.values, this.eof);
        }

        @NonNull
        @Generated
        public Document withMarkers(Markers markers) {
            return this.markers == markers ? this : new Document(this.id, this.sourcePath, this.prefix, markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.values, this.eof);
        }

        @NonNull
        @Generated
        public Document withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new Document(this.id, this.sourcePath, this.prefix, this.markers, this.charsetName, charsetBomMarked, this.checksum, this.fileAttributes, this.values, this.eof);
        }

        @NonNull
        @Generated
        public Document withChecksum(@Nullable Checksum checksum) {
            return this.checksum == checksum ? this : new Document(this.id, this.sourcePath, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, checksum, this.fileAttributes, this.values, this.eof);
        }

        @NonNull
        @Generated
        public Document withFileAttributes(@Nullable FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new Document(this.id, this.sourcePath, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, fileAttributes, this.values, this.eof);
        }

        @NonNull
        @Generated
        public Document withValues(List<TomlValue> values) {
            return this.values == values ? this : new Document(this.id, this.sourcePath, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, values, this.eof);
        }

        @NonNull
        @Generated
        public Document withEof(Space eof) {
            return this.eof == eof ? this : new Document(this.id, this.sourcePath, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.values, eof);
        }

        @NonNull
        @Generated
        private Document withCharsetName(String charsetName) {
            return this.charsetName == charsetName ? this : new Document(this.id, this.sourcePath, this.prefix, this.markers, charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.values, this.eof);
        }
    }

    public static final class Array
    implements Toml {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<TomlRightPadded<Toml>> values;

        public List<Toml> getValues() {
            return TomlRightPadded.getElements(this.values);
        }

        public Array withValues(List<Toml> values) {
            return this.getPadding().withValues(TomlRightPadded.withElements(this.values, values));
        }

        @Override
        public <P> Toml acceptToml(TomlVisitor<P> v, P p) {
            return v.visitArray(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Toml.Array(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", values=" + this.getValues() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Array)) {
                return false;
            }
            Array other = (Array)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Array(UUID id, Space prefix, Markers markers, List<TomlRightPadded<Toml>> values) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.values = values;
        }

        @Generated
        private Array(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<TomlRightPadded<Toml>> values) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.values = values;
        }

        @NonNull
        @Generated
        public Array withId(UUID id) {
            return this.id == id ? this : new Array(this.padding, id, this.prefix, this.markers, this.values);
        }

        @NonNull
        @Generated
        public Array withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Array(this.padding, this.id, prefix, this.markers, this.values);
        }

        @NonNull
        @Generated
        public Array withMarkers(Markers markers) {
            return this.markers == markers ? this : new Array(this.padding, this.id, this.prefix, markers, this.values);
        }

        public static class Padding {
            private final Array t;

            public List<TomlRightPadded<Toml>> getValues() {
                return this.t.values;
            }

            public Array withValues(List<TomlRightPadded<Toml>> values) {
                return this.t.values == values ? this.t : new Array(this.t.id, this.t.prefix, this.t.markers, values);
            }

            @Generated
            public Padding(Array t) {
                this.t = t;
            }
        }
    }
}

