/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.polyglot;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.polyglot.ProgressBar;
import org.openrewrite.polyglot.RemoteException;
import org.openrewrite.polyglot.RemoteProgressMessage;

public class RemoteProgressBarReceiver
implements ProgressBar {
    private static final ExecutorService PROGRESS_RECEIVER_POOL = Executors.newCachedThreadPool();
    private final ProgressBar delegate;
    private final DatagramSocket socket;
    private volatile boolean closed = false;
    private final AtomicReference<String> thrown = new AtomicReference();

    public RemoteProgressBarReceiver(ProgressBar delegate) {
        try {
            this.delegate = delegate;
            this.socket = new DatagramSocket();
            PROGRESS_RECEIVER_POOL.submit(this::receive);
        }
        catch (SocketException e) {
            throw new UncheckedIOException(e);
        }
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }

    public int receive() {
        block10: {
            LinkedHashMap<UUID, RemoteProgressMessage> incompleteMessages = new LinkedHashMap<UUID, RemoteProgressMessage>(){

                @Override
                protected boolean removeEldestEntry(Map.Entry<UUID, RemoteProgressMessage> eldest) {
                    return this.size() > 1000;
                }
            };
            try {
                while (!this.closed) {
                    RemoteProgressMessage message = RemoteProgressMessage.receive(this.socket, (Map<UUID, RemoteProgressMessage>)incompleteMessages);
                    if (message == null) continue;
                    switch (message.getType()) {
                        case Exception: {
                            if (message.getMessage() == null) break;
                            this.thrown.set(message.getMessage());
                            break;
                        }
                        case IntermediateResult: {
                            this.delegate.intermediateResult(message.getMessage());
                            break;
                        }
                        case Step: {
                            this.delegate.step();
                            break;
                        }
                        case SetExtraMessage: {
                            this.delegate.setExtraMessage(Objects.requireNonNull(message.getMessage()));
                            break;
                        }
                        case SetMax: {
                            this.delegate.setMax(Integer.parseInt(Objects.requireNonNull(message.getMessage())));
                        }
                    }
                }
            }
            catch (IOException e) {
                if (this.closed) break block10;
                throw new UncheckedIOException(e);
            }
        }
        return 0;
    }

    @Override
    public void intermediateResult(@Nullable String message) {
        this.maybeThrow();
        this.delegate.intermediateResult(message);
    }

    @Override
    public void finish(String message) {
        this.maybeThrow();
        this.delegate.finish(message);
    }

    @Override
    public void step() {
        this.maybeThrow();
        this.delegate.step();
    }

    @Override
    public ProgressBar setExtraMessage(String extraMessage) {
        this.maybeThrow();
        return this.delegate.setExtraMessage(extraMessage);
    }

    @Override
    public ProgressBar setMax(int max) {
        this.maybeThrow();
        return this.delegate.setMax(max);
    }

    @Override
    public void close() {
        this.closed = true;
        this.socket.close();
        this.maybeThrow();
    }

    private void maybeThrow() {
        String t = this.thrown.get();
        if (t != null) {
            throw RemoteException.decode(t);
        }
    }
}

