/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.polyglot;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.groovy.GroovyParser;
import org.openrewrite.hcl.HclParser;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.json.JsonParser;
import org.openrewrite.properties.PropertiesParser;
import org.openrewrite.protobuf.ProtoParser;
import org.openrewrite.shaded.jgit.api.Git;
import org.openrewrite.shaded.jgit.lib.FileMode;
import org.openrewrite.shaded.jgit.treewalk.AbstractTreeIterator;
import org.openrewrite.shaded.jgit.treewalk.FileTreeIterator;
import org.openrewrite.shaded.jgit.treewalk.TreeWalk;
import org.openrewrite.shaded.jgit.treewalk.WorkingTreeIterator;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.yaml.YamlParser;

public class OmniParser
implements Parser {
    private static final Collection<String> DEFAULT_IGNORED_DIRECTORIES = Arrays.asList("build", "target", "out", ".gradle", ".idea", ".project", "node_modules", ".git", ".metadata", ".DS_Store", ".moderne");
    private final Collection<Path> exclusions;
    private final Collection<PathMatcher> exclusionMatchers;
    private final int sizeThresholdMb;
    private final Collection<Path> excludedDirectories;
    private final boolean parallel;
    private final List<Parser> parsers;
    private final Consumer<Integer> onParse;

    public static List<Parser> defaultResourceParsers() {
        return new ArrayList<Parser>(Arrays.asList(new JsonParser(), new XmlParser(), new YamlParser(), new PropertiesParser(), new ProtoParser(), HclParser.builder().build(), GroovyParser.builder().build(), GradleParser.builder().build()));
    }

    public Stream<SourceFile> parseAll(Path rootDir) {
        return this.parse(this.acceptedPaths(rootDir), rootDir, (ExecutionContext)new InMemoryExecutionContext());
    }

    public Stream<SourceFile> parse(Iterable<Path> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        int count = 0;
        for (Path ignored : sourceFiles) {
            ++count;
        }
        this.onParse.accept(count);
        return super.parse(sourceFiles, relativeTo, ctx);
    }

    public List<Path> acceptedPaths(Path rootDir) {
        return this.acceptedPaths(rootDir, rootDir);
    }

    public List<Path> acceptedPaths(Path rootDir, Path searchDir) {
        if (!Files.exists(searchDir, new LinkOption[0])) {
            return Collections.emptyList();
        }
        ArrayList<Path> parseable = new ArrayList<Path>();
        try (Git git = Git.open((File)rootDir.toFile());
             TreeWalk walk = new TreeWalk(git.getRepository());){
            walk.addTree((AbstractTreeIterator)new FileTreeIterator(git.getRepository()));
            block12: while (walk.next()) {
                WorkingTreeIterator tree = (WorkingTreeIterator)walk.getTree(WorkingTreeIterator.class);
                if (tree.isEntryIgnored()) continue;
                Path path = rootDir.resolve(tree.getEntryPathString());
                if (tree.getEntryFileMode().equals(FileMode.TREE) && !this.isExcluded(path, rootDir) && !this.isIgnoredDirectory(path, searchDir) && !this.excludedDirectories.contains(path)) {
                    walk.enterSubtree();
                    continue;
                }
                if (tree.getEntryFileMode().equals(FileMode.SYMLINK) || this.isOverSizeThreshold(tree.getEntryContentLength()) || this.isExcluded(path, rootDir)) continue;
                for (Parser parser : this.parsers) {
                    if (!parser.accept(path)) continue;
                    parseable.add(path);
                    continue block12;
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return parseable;
    }

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        return StreamSupport.stream(sources.spliterator(), this.parallel).flatMap(input -> {
            Path path = input.getPath();
            for (Parser parser : this.parsers) {
                if (!parser.accept(path)) continue;
                return parser.parseInputs(Collections.singletonList(input), relativeTo, ctx);
            }
            return Stream.empty();
        });
    }

    public boolean accept(Path path) {
        for (Parser parser : this.parsers) {
            if (!parser.accept(path)) continue;
            return true;
        }
        return false;
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return Paths.get("resource.me", new String[0]);
    }

    private boolean isOverSizeThreshold(long fileSize) {
        return this.sizeThresholdMb > 0 && fileSize > (long)this.sizeThresholdMb * 1024L * 1024L;
    }

    boolean isExcluded(Path path, Path rootDir) {
        Path relativePath = rootDir.relativize(path);
        if (this.exclusions.contains(relativePath)) {
            return true;
        }
        for (PathMatcher excluded : this.exclusionMatchers) {
            if (!excluded.matches(relativePath)) continue;
            return true;
        }
        return false;
    }

    private boolean isIgnoredDirectory(Path path, Path rootDir) {
        for (Path pathSegment : rootDir.relativize(path)) {
            if (!DEFAULT_IGNORED_DIRECTORIES.contains(pathSegment.toString())) continue;
            return true;
        }
        return false;
    }

    public static Builder builder(Parser ... parsers) {
        return OmniParser.builder(Arrays.asList(parsers), new Parser[0]);
    }

    public static Builder builder(List<Parser> parsers, Parser ... more) {
        if (more.length > 0) {
            ArrayList<Parser> all = new ArrayList<Parser>(parsers);
            all.addAll(Arrays.asList(more));
            parsers = all;
        }
        return new Builder(parsers);
    }

    private OmniParser(Collection<Path> exclusions, Collection<PathMatcher> exclusionMatchers, int sizeThresholdMb, Collection<Path> excludedDirectories, boolean parallel, List<Parser> parsers, Consumer<Integer> onParse) {
        this.exclusions = exclusions;
        this.exclusionMatchers = exclusionMatchers;
        this.sizeThresholdMb = sizeThresholdMb;
        this.excludedDirectories = excludedDirectories;
        this.parallel = parallel;
        this.parsers = parsers;
        this.onParse = onParse;
    }

    public static class Builder
    extends Parser.Builder {
        private Collection<Path> exclusions = Collections.emptyList();
        private Collection<PathMatcher> exclusionMatchers = Collections.emptyList();
        private int sizeThresholdMb = 10;
        private Collection<Path> excludedDirectories = Collections.emptyList();
        private boolean parallel;
        private Consumer<Integer> onParse = inputCount -> {};
        private final List<Parser> parsers;

        public Builder(List<Parser> parsers) {
            super(SourceFile.class);
            this.parsers = parsers;
        }

        public Builder exclusions(Collection<Path> exclusions) {
            this.exclusions = exclusions;
            return this;
        }

        public Builder exclusionMatchers(Collection<PathMatcher> exclusions) {
            this.exclusionMatchers = exclusions;
            return this;
        }

        public Builder exclusionMatchers(Path basePath, Iterable<String> exclusions) {
            return this.exclusionMatchers(StreamSupport.stream(exclusions.spliterator(), false).map(o -> basePath.getFileSystem().getPathMatcher("glob:" + o)).collect(Collectors.toList()));
        }

        public Builder sizeThresholdMb(int sizeThresholdMb) {
            this.sizeThresholdMb = sizeThresholdMb;
            return this;
        }

        public Builder excludedDirectories(Collection<Path> excludedDirectories) {
            this.excludedDirectories = excludedDirectories;
            return this;
        }

        public Builder onParse(Consumer<Integer> onParse) {
            this.onParse = onParse;
            return this;
        }

        public Builder parallel(boolean parallel) {
            this.parallel = parallel;
            return this;
        }

        public OmniParser build() {
            return new OmniParser(this.exclusions, this.exclusionMatchers, this.sizeThresholdMb, this.excludedDirectories, this.parallel, this.parsers, this.onParse);
        }

        public String getDslName() {
            return "omni";
        }
    }
}

